<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Sign Up</title>
  <style>
    /* Reset & base */
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', Tahoma, sans-serif;
    }
    body {
      background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .container {
      width: 100%;
      max-width: 450px;
      padding: 20px;
    }
    .signup-form {
      background: #fff;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.15);
    }
    .signup-form h1 {
      text-align: center;
      color: #333;
      margin-bottom: 10px;
    }
    .subtitle {
      text-align: center;
      font-size: 0.9rem;
      color: #666;
      margin-bottom: 20px;
    }
    label {
      font-size: 0.9rem;
      color: #444;
      display: block;
      margin-bottom: 6px;
      margin-top: 14px;
    }
    input, select {
      width: 100%;
      padding: 12px;
      border: 1px solid #ccc;
      border-radius: 8px;
      transition: border-color 0.2s;
      margin-bottom: 4px;
    }
    input:focus, select:focus {
      outline: none;
      border-color: #4f46e5;
      box-shadow: 0 0 0 3px rgba(79,70,229,0.25);
    }
    button {
      width: 100%;
      padding: 12px;
      background: #4f46e5;
      color: #fff;
      font-size: 1rem;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      transition: background 0.2s;
      margin-top: 18px;
    }
    button:hover {
      background: #4338ca;
    }
    .links {
      text-align: center;
      margin-top: 15px;
    }
    .links a {
      font-size: 0.85rem;
      color: #4f46e5;
      text-decoration: none;
    }
    .links a:hover {
      text-decoration: underline;
    }
    @media (max-width: 480px) {
      .signup-form { padding: 20px; }
    }
  </style>
</head>
<body>
  <div class="container">
    <form class="signup-form" action="signup.php" method="POST">
      <h1>Create Account</h1>
      <p class="subtitle">Join us today—it’s quick and easy</p>

      <label for="fullname">Full Name</label>
      <input type="text" id="fullname" name="fullname" placeholder="John Doe" required>

      <label for="email">Email</label>
      <input type="email" id="email" name="email" placeholder="you@example.com" required>

      <label for="username">Username</label>
      <input type="text" id="username" name="username" placeholder="yourusername" required>

      <label for="phone">Phone</label>
      <input type="tel" id="phone" name="phone" placeholder="+1 234 567 8901" required>

      <label for="password">Password</label>
      <input type="password" id="password" name="password" placeholder="Enter a strong password" required>

      <label for="country">Country</label>
      <select id="country" name="country" required>
        <option value="" disabled selected>Select your country</option>
        <option value="Nigeria">Nigeria</option>
        <option value="United States">United States</option>
        <option value="United Kingdom">United Kingdom</option>
        <option value="Canada">Canada</option>
        <option value="Other">Other</option>
      </select>

      <label for="coupon">Coupon Code (optional)</label>
      <input type="text" id="coupon" name="coupon" placeholder="Enter coupon code">

      <label for="package">Select Package</label>
      <select id="package" name="package" required>
        <option value="" disabled selected>Select a package</option>
        <option value="basic">Basic</option>
        <option value="standard">Standard</option>
        <option value="premium">Premium</option>
      </select>

      <label for="referredby">Referred By (username)</label>
      <input type="text" id="referredby" name="referredby" placeholder="Referrer username">

      <button type="submit">Sign Up</button>

      <div class="links">
        Already have an account? <a href="login.html">Log in</a>
      </div>
    </form>
  </div>
</body>
</html>