<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login</title>
  <style>
/* Reset defaults */
* {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  font-family: 'Segoe UI', Tahoma, sans-serif;
}

body {
  /* Blue–purple gradient background */
  background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
  min-height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
}

.container {
  width: 100%;
  max-width: 380px;
  padding: 20px;
}

.login-form {
  background: #ffffff;       /* clean white card */
  border-radius: 12px;
  padding: 30px;
  box-shadow: 0 8px 24px rgba(0,0,0,0.15);
}

.login-form h1 {
  text-align: center;
  color: #333;
  margin-bottom: 6px;
}

.subtitle {
  text-align: center;
  font-size: 0.9rem;
  color: #666;
  margin-bottom: 20px;
}

label {
  font-size: 0.9rem;
  color: #444;
  display: block;
  margin-bottom: 6px;
}

input[type="email"],
input[type="password"] {
  width: 100%;
  padding: 12px;
  margin-bottom: 18px;
  border: 1px solid #ccc;
  border-radius: 8px;
  transition: border-color 0.2s;
}

input:focus {
  outline: none;
  border-color: #4f46e5; /* indigo focus */
  box-shadow: 0 0 0 3px rgba(79,70,229,0.25);
}

button {
  width: 100%;
  padding: 12px;
  background: #4f46e5;   /* indigo button */
  color: #fff;
  font-size: 1rem;
  border: none;
  border-radius: 8px;
  cursor: pointer;
  transition: background 0.2s;
}

button:hover {
  background: #4338ca;   /* darker indigo on hover */
}

.links {
  display: flex;
  justify-content: space-between;
  margin-top: 15px;
}

.links a {
  font-size: 0.85rem;
  color: #4f46e5;
  text-decoration: none;
}

.links a:hover {
  text-decoration: underline;
}

/* Mobile tweaks */
@media (max-width: 400px) {
  .login-form {
    padding: 20px;
  }
}
  </style>
</head>
<body>
  <div class="container">
    <form class="login-form" action="login.php" method="POST">
      <h1>Welcome Back</h1>
      <p class="subtitle">Sign in to continue</p>

      <label for="email">Email</label>
      <input type="email" id="email" name="email" placeholder="you@example.com" required>

      <label for="password">Password</label>
      <input type="password" id="password" name="password" placeholder="Enter your password" required>

      <button type="submit">Log In</button>

      <div class="links">
        <a href="#">Forgot password?</a>
        <a href="register.html">Create account</a>
      </div>
    </form>
  </div>
</body>
</html>