<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Withdraw Funds</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      color:#2d2a35;
      min-height:100vh;
      padding:20px;
    }

    .withdraw-container{
      max-width:450px;
      margin:40px auto;
      background:#fff;
      border-radius:20px;
      padding:30px 25px;
      box-shadow:0 8px 25px rgba(0,0,0,0.08);
    }

    h1{
      text-align:center;
      color:#4b3cbf;
      margin-bottom:25px;
      font-size:22px;
      font-weight:600;
    }

    form label{
      display:block;
      margin-bottom:6px;
      font-weight:600;
      color:#2d2a35;
      font-size:15px;
    }

    form select,
    form input{
      width:100%;
      padding:12px 14px;
      margin-bottom:18px;
      border:1px solid #ccc;
      border-radius:10px;
      font-size:15px;
      transition:border-color .2s;
    }
    form select:focus,
    form input:focus{
      border-color:#9D4EDD;
      outline:none;
    }

    .submit-btn{
      width:100%;
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      border:none;
      padding:12px 0;
      border-radius:12px;
      font-size:16px;
      font-weight:600;
      cursor:pointer;
      transition:background .3s;
    }
    .submit-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }

    .note{
      font-size:13px;
      color:#555;
      margin-top:15px;
      text-align:center;
      line-height:1.4;
    }
  </style>
</head>
<body>

  <div class="withdraw-container">
    <h1><i class="fa-solid fa-wallet"></i> Withdraw Funds</h1>
    <form action="process_withdrawal.php" method="POST">
      <!-- Choose Wallet -->
      <label for="wallet">Select Wallet</label>
      <select id="wallet" name="wallet" required>
        <option value="" disabled selected>-- Choose Wallet --</option>
        <option value="main">Main Wallet</option>
        <option value="affiliate">Affiliate Wallet</option>
        <option value="task">Task Wallet</option>
      </select>

      <!-- Amount -->
      <label for="amount">Withdrawal Amount (₦)</label>
      <input type="number" id="amount" name="amount" min="100" step="50" placeholder="Enter amount" required>

      <!-- Payment Method -->
      <label for="method">Payment Method</label>
      <select id="method" name="method" required>
        <option value="" disabled selected>-- Select Method --</option>
        <option value="bank">Bank Transfer</option>
        <option value="mobile_money">Mobile Money</option>
      </select>

      <!-- Account Details -->
      <label for="details">Account Details</label>
      <input type="text" id="details" name="details" placeholder="Account number or Mobile Money ID" required>

      <button type="submit" class="submit-btn">Place Withdrawal</button>
      <p class="note">
        Minimum withdrawal is ₦100. Processing may take up to 24 hours.
      </p>
    </form>
  </div>

</body>
</html>