<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Vendor Dashboard</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    padding:20px;
    min-height:100vh;
  }

  h1{
    text-align:center;
    margin-bottom:30px;
    color:#4b3cbf;
    font-weight:600;
  }

  /* ===== SUMMARY CARDS ===== */
  .summary-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(180px,1fr));
    gap:15px;
    max-width:1000px;
    margin:0 auto 40px;
  }
  .summary-card{
    background:#fff;
    border-radius:18px;
    padding:20px;
    text-align:center;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
    transition:transform .2s;
  }
  .summary-card:hover{
    transform:translateY(-5px);
  }
  .summary-card i{
    font-size:28px;
    color:#9D4EDD;
    margin-bottom:10px;
  }
  .summary-card h3{
    font-size:16px;
    margin-bottom:4px;
  }
  .summary-card p{
    font-size:20px;
    font-weight:700;
    color:#4b3cbf;
  }

  /* ===== TABLE ===== */
  .coupon-table-wrapper{
    max-width:1000px;
    margin:0 auto;
    overflow-x:auto;
    background:#fff;
    border-radius:16px;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
  }
  table{
    width:100%;
    border-collapse:collapse;
    min-width:600px;
  }
  thead{
    background:#9D4EDD;
    color:#fff;
  }
  th, td{
    padding:14px 12px;
    text-align:left;
    font-size:14px;
  }
  tbody tr:nth-child(even){
    background:#f5f3fa;
  }
  .status{
    font-weight:600;
    padding:4px 10px;
    border-radius:12px;
    font-size:13px;
    text-align:center;
    display:inline-block;
  }
  .status.available{
    background:#e3ffe3;
    color:#2e7d32;
  }
  .status.used{
    background:#ffe3e3;
    color:#c62828;
  }
  .status.pending{
    background:#fff3cd;
    color:#b38300;
  }

  /* Responsive tweaks */
  @media(max-width:600px){
    th, td{font-size:13px;padding:10px;}
  }
</style>
</head>
<body>

<h1>Vendor Dashboard</h1>

<!-- Top Summary Boxes -->
<section class="summary-grid">
  <div class="summary-card">
    <i class="fa-solid fa-ticket"></i>
    <h3>Total Coupons</h3>
    <p>120</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-check-circle"></i>
    <h3>Sold</h3>
    <p>85</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-box-open"></i>
    <h3>Remaining</h3>
    <p>35</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-wallet"></i>
    <h3>Total Earnings</h3>
    <p>₦150,000</p>
  </div>
</section>

<!-- Coupon Table -->
<div class="coupon-table-wrapper">
  <table>
    <thead>
      <tr>
        <th>Coupon Code</th>
        <th>Package</th>
        <th>Value (₦)</th>
        <th>Status</th>
        <th>Buyer</th>
        <th>Date Issued</th>
      </tr>
    </thead>
    <tbody>
      <!-- Replace these rows with PHP loop fetching from DB -->
      <tr>
        <td>ABC123</td>
        <td>Premium</td>
        <td>5,000</td>
        <td><span class="status available">Available</span></td>
        <td>-</td>
        <td>2025-09-15</td>
      </tr>
      <tr>
        <td>XYZ789</td>
        <td>Basic</td>
        <td>3,000</td>
        <td><span class="status used">Used</span></td>
        <td>john@example.com</td>
        <td>2025-09-12</td>
      </tr>
      <tr>
        <td>LMN456</td>
        <td>Standard</td>
        <td>4,000</td>
        <td><span class="status pending">Pending</span></td>
        <td>-</td>
        <td>2025-09-14</td>
      </tr>
    </tbody>
  </table>
</div>

</body>
</html>