<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<title>Available Tasks</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  * {box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body {
    background:#f5f3fa;
    color:#2d2a35;
    min-height:100vh;
    padding:20px;
  }

  h1 {
    text-align:center;
    margin-bottom:25px;
    font-weight:600;
    color:#4b3cbf;
  }

  /* ===== TASK GRID ===== */
  .task-grid {
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
    gap:20px;
    max-width:1000px;
    margin:0 auto;
  }

  .task-card {
    background:#fff;
    border-radius:16px;
    padding:20px;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
    display:flex;
    flex-direction:column;
    justify-content:space-between;
    transition:transform .2s;
  }
  .task-card:hover { transform:translateY(-5px); }

  .task-header {
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:10px;
  }
  .task-header h3 {
    font-size:18px;
    color:#4b3cbf;
    font-weight:600;
  }
  .task-header i { font-size:22px; color:#9D4EDD; }

  .task-desc {
    font-size:14px;
    color:#555;
    margin-bottom:15px;
    line-height:1.4;
  }

  .task-footer {
    display:flex;
    justify-content:space-between;
    gap:10px;
    margin-top:auto;
  }
  .task-footer button {
    flex:1;
    border:none;
    padding:10px 0;
    border-radius:8px;
    cursor:pointer;
    font-weight:600;
    color:#fff;
    font-size:14px;
    transition:background .2s;
  }
  .perform-btn { background:linear-gradient(135deg,#5e4bff,#8a66ff); }
  .perform-btn:hover { background:linear-gradient(135deg,#4e3ce6,#7a59ff); }

  .claim-btn { background:linear-gradient(135deg,#4CAF50,#66BB6A); }
  .claim-btn:hover { background:linear-gradient(135deg,#43A047,#5cbf60); }
</style>
</head>
<body>

<h1>Available Tasks</h1>

<section class="task-grid">
  <!-- Repeat these cards dynamically with PHP/JS -->
  <div class="task-card">
    <div class="task-header">
      <h3>Watch a 2-minute Ad</h3>
    </div>
    <p class="task-desc">Watch the short video ad to earn ₦200. Make sure to view it completely to qualify.</p>
    <div class="task-footer">
      <button class="perform-btn" onclick="performTask(1)">Perform Task</button>
      <button class="claim-btn" onclick="claimReward(1)">Claim Reward</button>
    </div>
  </div>

  <div class="task-card">
    <div class="task-header">
      <h3>Share on Social Media</h3>
    </div>
    <p class="task-desc">Share our latest campaign on Facebook or Twitter to earn ₦150.</p>
    <div class="task-footer">
      <button class="perform-btn" onclick="performTask(2)">Perform Task</button>
      <button class="claim-btn" onclick="claimReward(2)">Claim Reward</button>
    </div>
  </div>

  <div class="task-card">
    <div class="task-header">
      <h3>Fill a Survey</h3>
    </div>
    <p class="task-desc">Complete a quick 5-question survey to receive ₦100 reward.</p>
    <div class="task-footer">
      <button class="perform-btn" onclick="performTask(3)">Perform Task</button>
      <button class="claim-btn" onclick="claimReward(3)">Claim Reward</button>
    </div>
  </div>
</section>

<script>
  function performTask(id){
    // Replace with real logic (e.g., redirect to task page or AJAX)
    alert("Performing Task ID: " + id);
  }
  function claimReward(id){
    // Replace with real logic (e.g., API call to claim reward)
    alert("Claiming reward for Task ID: " + id);
  }
</script>

</body>
</html>