<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Sponsored Posts</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Poppins', sans-serif; }
  body {
    background: #f5f3fa;
    color: #2d2a35;
    padding: 20px;
    min-height: 100vh;
  }

  h1 {
    text-align: center;
    margin-bottom: 25px;
    color: #4b3cbf;
    font-weight: 600;
  }

  /* ===== GRID ===== */
  .sponsored-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
    max-width: 1000px;
    margin: 0 auto;
  }

  .sponsored-card {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.08);
    display: flex;
    flex-direction: column;
    transition: transform 0.2s;
  }
  .sponsored-card:hover { transform: translateY(-5px); }

  .sponsored-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
  }
  .sponsored-header h3 {
    font-size: 18px;
    color: #4b3cbf;
    font-weight: 600;
  }
  .sponsored-header i {
    font-size: 22px;
    color: #9D4EDD;
  }

  .sponsored-desc {
    font-size: 14px;
    color: #555;
    margin-bottom: 15px;
    line-height: 1.4;
  }

  .sponsored-footer {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    margin-top: auto;
  }
  .sponsored-footer button {
    flex: 1;
    border: none;
    padding: 10px 0;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 600;
    color: #fff;
    font-size: 14px;
    transition: background 0.2s;
  }

  .view-btn {
    background: linear-gradient(135deg, #5e4bff, #8a66ff);
  }
  .view-btn:hover {
    background: linear-gradient(135deg, #4e3ce6, #7a59ff);
  }

  .claim-btn {
    background: linear-gradient(135deg, #4CAF50, #66BB6A);
  }
  .claim-btn:hover {
    background: linear-gradient(135deg, #43A047, #5cbf60);
  }
</style>
</head>
<body>

<h1>Sponsored Posts</h1>

<section class="sponsored-grid">
  <!-- Repeat these sponsored-card blocks dynamically with PHP/JS -->
  <div class="sponsored-card">
    <div class="sponsored-header">
      <h3>Brand X Campaign</h3>
    </div>
    <p class="sponsored-desc">
      Visit Brand X’s landing page and read the article to qualify for a ₦200 reward.
    </p>
    <div class="sponsored-footer">
      <button class="view-btn" onclick="viewPost(1)">View Post</button>
      <button class="claim-btn" onclick="claimReward(1)">Claim Reward</button>
    </div>
  </div>

  <div class="sponsored-card">
    <div class="sponsored-header">
      <h3>Product Y Review</h3>
    </div>
    <p class="sponsored-desc">
      Read and share a quick review of Product Y to earn ₦150.
    </p>
    <div class="sponsored-footer">
      <button class="view-btn" onclick="viewPost(2)">View Post</button>
      <button class="claim-btn" onclick="claimReward(2)">Claim Reward</button>
    </div>
  </div>

  <div class="sponsored-card">
    <div class="sponsored-header">
      <h3>Service Z Promo</h3>
    </div>
    <p class="sponsored-desc">
      Check out Service Z’s promotional page to collect your ₦100 reward.
    </p>
    <div class="sponsored-footer">
      <button class="view-btn" onclick="viewPost(3)">View Post</button>
      <button class="claim-btn" onclick="claimReward(3)">Claim Reward</button>
    </div>
  </div>
</section>

<script>
function viewPost(id) {
  // Replace with logic to open or redirect to the sponsored content
  alert("Opening Sponsored Post ID: " + id);
  // Example: window.location.href = 'sponsored_view.php?id=' + id;
}

function claimReward(id) {
  // Replace with AJAX or backend logic to claim reward
  alert("Claiming reward for Sponsored Post ID: " + id);
}
</script>

</body>
</html>