<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Spin & Win</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    min-height:100vh;
    display:flex;
    flex-direction:column;
    align-items:center;
    justify-content:center;
    padding:20px;
  }

  h1{
    margin-bottom:25px;
    color:#4b3cbf;
    font-weight:600;
    text-align:center;
  }

  /* ===== WHEEL WRAPPER ===== */
  .wheel-container{
    position:relative;
    width:300px;
    height:300px;
    margin-bottom:30px;
  }
  canvas{
    width:100%;
    height:100%;
    border-radius:50%;
    box-shadow:0 8px 25px rgba(0,0,0,.2);
    background:#fff;
  }

  /* Arrow indicator */
  .pointer{
    position:absolute;
    top:50%;
    left:50%;
    transform:translate(-50%,-150%);
    width:0;
    height:0;
    border-left:20px solid transparent;
    border-right:20px solid transparent;
    border-bottom:30px solid #9D4EDD;
  }

  /* Spin Button */
  .spin-btn{
    background:linear-gradient(135deg,#5e4bff,#8a66ff);
    color:#fff;
    border:none;
    padding:15px 40px;
    border-radius:50px;
    font-size:18px;
    font-weight:600;
    cursor:pointer;
    box-shadow:0 6px 18px rgba(0,0,0,.15);
    transition:background .3s;
  }
  .spin-btn:hover{
    background:linear-gradient(135deg,#4e3ce6,#7a59ff);
  }

  /* Prize text */
  #result{
    margin-top:20px;
    font-size:18px;
    font-weight:600;
    color:#4b3cbf;
    text-align:center;
    min-height:28px;
  }
</style>
</head>
<body>

<h1>Spin & Win</h1>

<div class="wheel-container">
  <div class="pointer"></div>
  <canvas id="wheel" width="300" height="300"></canvas>
</div>

<button class="spin-btn" onclick="spin()">SPIN</button>
<p id="result"></p>

<script>
/* === CONFIGURATION === */
const prizes = ["₦500", "₦1,000", "₦200", "Try Again", "₦2,000", "₦100", "₦300", "Bonus Spin"];
const colors = ["#9D4EDD","#5E4BFF","#8A66FF","#B388FF","#7C4DFF","#9575CD","#673AB7","#9C27B0"];
const wheel = document.getElementById('wheel');
const ctx = wheel.getContext('2d');
const slice = 360 / prizes.length;
let angle = 0;
let spinning = false;

/* === DRAW WHEEL === */
function drawWheel(){
  for(let i=0;i<prizes.length;i++){
    const startAngle = (slice * i) * Math.PI/180;
    const endAngle = (slice * (i+1)) * Math.PI/180;
    ctx.beginPath();
    ctx.moveTo(150,150);
    ctx.arc(150,150,150,startAngle,endAngle);
    ctx.fillStyle = colors[i % colors.length];
    ctx.fill();
    ctx.save();
    ctx.translate(150,150);
    ctx.rotate((startAngle + endAngle)/2);
    ctx.textAlign = "right";
    ctx.fillStyle = "#fff";
    ctx.font = "bold 16px Poppins";
    ctx.fillText(prizes[i],130,5);
    ctx.restore();
  }
}
drawWheel();

/* === SPIN LOGIC === */
function spin(){
  if(spinning) return;
  spinning = true;
  const spinAngle = Math.random() * 360 + 720; // at least 2 full turns
  const duration = 4000;
  const start = performance.now();

  function animate(now){
    const elapsed = now - start;
    const progress = Math.min(elapsed / duration, 1);
    angle = spinAngle * easeOutCubic(progress);
    wheel.style.transform = `rotate(${angle}deg)`;

    if(progress < 1){
      requestAnimationFrame(animate);
    } else {
      spinning = false;
      const finalAngle = (angle % 360);
      const index = Math.floor((360 - finalAngle + slice/2) % 360 / slice);
      document.getElementById('result').textContent = "You won: " + prizes[index];
    }
  }
  requestAnimationFrame(animate);
}

function easeOutCubic(t){ return 1 - Math.pow(1 - t, 3); }
</script>

</body>
</html>