<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Our Channels & Groups</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      color:#2d2a35;
      padding:20px;
      min-height:100vh;
    }

    h1{
      text-align:center;
      font-size:24px;
      font-weight:600;
      color:#5e4bff;
      margin-bottom:30px;
    }

    .channels-grid{
      display:grid;
      grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
      gap:20px;
      max-width:1000px;
      margin:0 auto;
    }

    .channel-card{
      background:#fff;
      border-radius:16px;
      padding:20px;
      text-align:center;
      box-shadow:0 6px 18px rgba(0,0,0,.08);
      transition:transform .2s;
    }
    .channel-card:hover{
      transform:translateY(-5px);
    }

    .channel-card i{
      font-size:40px;
      margin-bottom:10px;
      color:#5e4bff;
    }

    .channel-card h3{
      font-size:18px;
      margin-bottom:8px;
      font-weight:600;
    }
    .channel-card p{
      font-size:14px;
      margin-bottom:15px;
      color:#555;
    }

    .join-btn{
      display:inline-block;
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      text-decoration:none;
      padding:10px 20px;
      border-radius:10px;
      font-weight:600;
      transition:background .3s;
    }
    .join-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }
  </style>
</head>
<body>

  <h1><i class="fa-solid fa-share-nodes"></i> Our Official Channels & Groups</h1>

  <div class="channels-grid">
    <!-- Repeat these blocks dynamically if needed -->
    <div class="channel-card">
      <i class="fab fa-telegram"></i>
      <h3>Telegram Group</h3>
      <p>Join our official discussion group for updates & community chat.</p>
      <a href="https://t.me/YourPlatform" target="_blank" class="join-btn">Join</a>
    </div>

    <div class="channel-card">
      <i class="fab fa-whatsapp"></i>
      <h3>WhatsApp Community</h3>
      <p>Connect with members and get instant notifications.</p>
      <a href="https://chat.whatsapp.com/YourInvite" target="_blank" class="join-btn">Join</a>
    </div>

    <div class="channel-card">
      <i class="fab fa-twitter"></i>
      <h3>X (Twitter)</h3>
      <p>Follow us for real-time updates and announcements.</p>
      <a href="https://twitter.com/YourHandle" target="_blank" class="join-btn">Follow</a>
    </div>

    <div class="channel-card">
      <i class="fab fa-instagram"></i>
      <h3>Instagram</h3>
      <p>See our latest posts, reels, and behind-the-scenes stories.</p>
      <a href="https://instagram.com/YourHandle" target="_blank" class="join-btn">Follow</a>
    </div>

    <div class="channel-card">
      <i class="fab fa-facebook"></i>
      <h3>Facebook Page</h3>
      <p>Join our Facebook community and stay connected.</p>
      <a href="https://facebook.com/YourPage" target="_blank" class="join-btn">Like Page</a>
    </div>
  </div>

</body>
</html>