<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quiz: General Knowledge</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      color:#2d2a35;
      min-height:100vh;
      padding:20px;
    }

    .quiz-container{
      max-width:800px;
      margin:0 auto;
      background:#fff;
      border-radius:20px;
      padding:30px 25px;
      box-shadow:0 8px 25px rgba(0,0,0,0.08);
    }

    h1{
      text-align:center;
      font-size:24px;
      font-weight:600;
      color:#4b3cbf;
      margin-bottom:10px;
    }

    .quiz-meta{
      text-align:center;
      font-size:14px;
      color:#666;
      margin-bottom:25px;
    }

    .question{
      margin-bottom:25px;
      padding-bottom:20px;
      border-bottom:1px solid #eee;
    }

    .question h3{
      font-size:18px;
      margin-bottom:12px;
      font-weight:600;
      color:#2d2a35;
    }

    .options label{
      display:block;
      background:#f1edff;
      margin-bottom:10px;
      padding:10px 14px;
      border-radius:10px;
      cursor:pointer;
      transition:background .2s;
    }
    .options input[type="radio"]{
      display:none;
    }
    .options label:hover{
      background:#e4dbff;
    }
    .options input[type="radio"]:checked + label{
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
    }

    .submit-btn{
      width:100%;
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      border:none;
      padding:12px;
      border-radius:12px;
      font-size:16px;
      font-weight:600;
      cursor:pointer;
      transition:background .3s;
      margin-top:15px;
    }
    .submit-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }

    @media(max-width:500px){
      h1{font-size:20px;}
      .question h3{font-size:16px;}
    }
  </style>
</head>
<body>

  <div class="quiz-container">
    <h1><i class="fa-solid fa-question-circle"></i> General Knowledge Quiz</h1>
    <p class="quiz-meta">10 Questions • 5 Minutes</p>

    <form action="submit_quiz.php" method="POST">
      <!-- Loop through questions dynamically from server -->
      
      <div class="question">
        <h3>1. What is the capital of France?</h3>
        <div class="options">
          <input type="radio" id="q1a" name="q1" value="Paris" required>
          <label for="q1a">Paris</label>

          <input type="radio" id="q1b" name="q1" value="Berlin">
          <label for="q1b">Berlin</label>

          <input type="radio" id="q1c" name="q1" value="Rome">
          <label for="q1c">Rome</label>

          <input type="radio" id="q1d" name="q1" value="Madrid">
          <label for="q1d">Madrid</label>
        </div>
      </div>

      <div class="question">
        <h3>2. Which planet is known as the Red Planet?</h3>
        <div class="options">
          <input type="radio" id="q2a" name="q2" value="Venus" required>
          <label for="q2a">Venus</label>

          <input type="radio" id="q2b" name="q2" value="Mars">
          <label for="q2b">Mars</label>

          <input type="radio" id="q2c" name="q2" value="Jupiter">
          <label for="q2c">Jupiter</label>

          <input type="radio" id="q2d" name="q2" value="Mercury">
          <label for="q2d">Mercury</label>
        </div>
      </div>

      <!-- Add more questions dynamically as needed -->

      <button type="submit" class="submit-btn">Submit Answers</button>
    </form>
  </div>

</body>
</html>