<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Available Quizzes</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      color:#2d2a35;
      min-height:100vh;
      padding:20px;
    }

    h1{
      text-align:center;
      font-size:26px;
      font-weight:600;
      color:#4b3cbf;
      margin-bottom:25px;
    }

    /* Quiz Grid */
    .quiz-grid{
      display:grid;
      grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
      gap:20px;
      max-width:1000px;
      margin:0 auto;
    }

    .quiz-card{
      background:#fff;
      border-radius:16px;
      box-shadow:0 8px 20px rgba(0,0,0,.08);
      padding:20px;
      text-align:center;
      transition:transform .2s, box-shadow .2s;
    }
    .quiz-card:hover{
      transform:translateY(-6px);
      box-shadow:0 10px 24px rgba(0,0,0,.12);
    }

    .quiz-icon{
      font-size:40px;
      margin-bottom:12px;
      color:#7a59ff;
    }

    .quiz-card h3{
      font-size:18px;
      font-weight:600;
      margin-bottom:8px;
      color:#2d2a35;
    }

    .quiz-meta{
      font-size:14px;
      color:#555;
      margin-bottom:15px;
    }

    .start-btn{
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      border:none;
      padding:10px 16px;
      border-radius:10px;
      font-size:14px;
      font-weight:600;
      cursor:pointer;
      transition:background .3s;
    }
    .start-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }

    /* Responsive text adjustments */
    @media (max-width:480px){
      h1{font-size:22px;}
      .quiz-card h3{font-size:16px;}
    }
  </style>
</head>
<body>

  <h1><i class="fa-solid fa-question-circle"></i> Available Quizzes</h1>

  <section class="quiz-grid">
    <!-- Example quiz card -->
    <div class="quiz-card">
      <div class="quiz-icon"><i class="fa-solid fa-lightbulb"></i></div>
      <h3>General Knowledge</h3>
      <p class="quiz-meta">10 Questions • 5 min</p>
      <button class="start-btn" onclick="startQuiz('general')">Start Quiz</button>
    </div>

    <div class="quiz-card">
      <div class="quiz-icon"><i class="fa-solid fa-code"></i></div>
      <h3>HTML & CSS Basics</h3>
      <p class="quiz-meta">15 Questions • 8 min</p>
      <button class="start-btn" onclick="startQuiz('htmlcss')">Start Quiz</button>
    </div>

    <div class="quiz-card">
      <div class="quiz-icon"><i class="fa-solid fa-calculator"></i></div>
      <h3>Math Challenge</h3>
      <p class="quiz-meta">20 Questions • 10 min</p>
      <button class="start-btn" onclick="startQuiz('math')">Start Quiz</button>
    </div>

    <!-- Add more quizzes dynamically from server here -->
  </section>

  <script>
    function startQuiz(quizId){
      // Replace with your actual route or logic
      window.location.href = 'quiz_start.php?id=' + encodeURIComponent(quizId);
    }
  </script>

</body>
</html>