<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Update Profile</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      min-height:100vh;
      padding:20px;
      color:#2d2a35;
    }

    .profile-container{
      max-width:500px;
      margin:40px auto;
      background:#fff;
      border-radius:20px;
      padding:30px 25px;
      box-shadow:0 8px 25px rgba(0,0,0,0.08);
    }

    h1{
      text-align:center;
      font-size:24px;
      font-weight:600;
      margin-bottom:25px;
      color:#4b3cbf;
    }

    label{
      display:block;
      margin-bottom:6px;
      font-weight:600;
      font-size:15px;
      color:#2d2a35;
    }

    input, select, textarea{
      width:100%;
      padding:12px 14px;
      margin-bottom:18px;
      border:1px solid #ccc;
      border-radius:10px;
      font-size:15px;
      transition:border-color .2s;
    }
    input:focus, select:focus, textarea:focus{
      border-color:#9D4EDD;
      outline:none;
    }

    .submit-btn{
      width:100%;
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      border:none;
      padding:12px 0;
      border-radius:12px;
      font-size:16px;
      font-weight:600;
      cursor:pointer;
      transition:background .3s;
    }
    .submit-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }

    .note{
      font-size:13px;
      color:#555;
      text-align:center;
      margin-top:15px;
      line-height:1.4;
    }
  </style>
</head>
<body>

  <div class="profile-container">
    <h1><i class="fa-solid fa-user-pen"></i> Update Profile</h1>

    <form action="update_profile.php" method="POST" enctype="multipart/form-data">
      <!-- Full Name -->
      <label for="fullname">Full Name</label>
      <input type="text" id="fullname" name="fullname" placeholder="John Doe" required>

      <!-- Username -->
      <label for="username">Username</label>
      <input type="text" id="username" name="username" placeholder="johndoe123" required>

      <!-- Email -->
      <label for="email">Email</label>
      <input type="email" id="email" name="email" placeholder="you@example.com" required>

      <!-- Phone -->
      <label for="phone">Phone Number</label>
      <input type="tel" id="phone" name="phone" placeholder="08012345678" required>

      <!-- Country -->
      <label for="country">Country</label>
      <select id="country" name="country" required>
        <option value="" disabled selected>Select Country</option>
        <option value="Nigeria">Nigeria</option>
        <option value="Ghana">Ghana</option>
        <option value="Kenya">Kenya</option>
        <option value="South Africa">South Africa</option>
        <!-- add more as needed -->
      </select>

      <!-- Profile Picture -->
      <label for="profile_pic">Profile Picture</label>
      <input type="file" id="profile_pic" name="profile_pic" accept="image/*">

      <!-- Bio -->
      <label for="bio">Short Bio</label>
      <textarea id="bio" name="bio" rows="4" placeholder="Tell us something about yourself..."></textarea>

      <button type="submit" class="submit-btn">Save Changes</button>

      <p class="note">
        Make sure your details are accurate. Changes will update immediately after saving.
      </p>
    </form>
  </div>

</body>
</html>