<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Marketplace</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <style>
    * { box-sizing:border-box; margin:0; padding:0; font-family:'Poppins',sans-serif; }
    body {
      background:#f5f3fa;     /* soft lavender background */
      color:#2d2a35;
      padding:20px;
      min-height:100vh;
    }

    h1 {
      text-align:center;
      color:#4b3cbf;
      font-weight:600;
      margin-bottom:30px;
    }

    /* ======= PRODUCTS GRID ======= */
    .product-grid {
      display:grid;
      grid-template-columns:repeat(auto-fit, minmax(220px, 1fr));
      gap:20px;
      max-width:1200px;
      margin:0 auto;
    }

    .product-card {
      background:#fff;
      border-radius:16px;
      overflow:hidden;
      box-shadow:0 6px 18px rgba(0,0,0,0.08);
      display:flex;
      flex-direction:column;
      transition:transform .2s, box-shadow .2s;
    }
    .product-card:hover {
      transform:translateY(-6px);
      box-shadow:0 12px 28px rgba(0,0,0,0.12);
    }

    .product-img {
      width:100%;
      height:180px;
      object-fit:cover;
    }

    .product-content {
      padding:16px;
      flex:1;
      display:flex;
      flex-direction:column;
      justify-content:space-between;
    }

    .product-title {
      font-size:17px;
      font-weight:600;
      margin-bottom:8px;
      color:#2d2a35;
    }

    .product-desc {
      font-size:14px;
      color:#555;
      margin-bottom:12px;
      line-height:1.4;
    }

    .product-price {
      font-size:16px;
      font-weight:600;
      color:#4b3cbf;
      margin-bottom:12px;
    }

    .cart-btn {
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      border:none;
      color:#fff;
      padding:10px 14px;
      border-radius:10px;
      font-size:14px;
      cursor:pointer;
      transition:background .3s;
      display:inline-flex;
      align-items:center;
      justify-content:center;
      gap:6px;
    }
    .cart-btn:hover {
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }
  </style>
</head>
<body>

  <h1>Marketplace</h1>

  <section class="product-grid">

    <!-- Product Item -->
    <div class="product-card">
      <img src="https://source.unsplash.com/400x300/?headphones" alt="Wireless Headphones" class="product-img">
      <div class="product-content">
        <div>
          <h2 class="product-title">Wireless Headphones</h2>
          <p class="product-desc">Noise-cancelling over-ear headphones with crystal-clear sound and 20h battery life.</p>
        </div>
        <div>
          <div class="product-price">₦25,000</div>
          <button class="cart-btn" onclick="addToCart('Wireless Headphones', 25000)">
            <i class="fa-solid fa-cart-plus"></i> Add to Cart
          </button>
        </div>
      </div>
    </div>

    <div class="product-card">
      <img src="https://source.unsplash.com/400x300/?laptop" alt="Laptop" class="product-img">
      <div class="product-content">
        <div>
          <h2 class="product-title">15&quot; Laptop</h2>
          <p class="product-desc">Slim and powerful laptop with 8GB RAM and 512GB SSD, perfect for work and play.</p>
        </div>
        <div>
          <div class="product-price">₦320,000</div>
          <button class="cart-btn" onclick="addToCart('15 Laptop', 320000)">
            <i class="fa-solid fa-cart-plus"></i> Add to Cart
          </button>
        </div>
      </div>
    </div>

    <div class="product-card">
      <img src="https://source.unsplash.com/400x300/?smartphone" alt="Smartphone" class="product-img">
      <div class="product-content">
        <div>
          <h2 class="product-title">Smartphone</h2>
          <p class="product-desc">6.5&quot; display, triple camera setup and all-day battery in a sleek design.</p>
        </div>
        <div>
          <div class="product-price">₦150,000</div>
          <button class="cart-btn" onclick="addToCart('Smartphone', 150000)">
            <i class="fa-solid fa-cart-plus"></i> Add to Cart
          </button>
        </div>
      </div>
    </div>

    <!-- Add more product cards as needed -->

  </section>

  <script>
    function addToCart(productName, price) {
      alert(`Added ${productName} (₦${price.toLocaleString()}) to cart.`);
      // Here you can make an AJAX request or redirect to a checkout/cart page
    }
  </script>

</body>
</html>