<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Dashboard</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    * {box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body {
      background:#f5f3fa;        /* soft lavender backdrop */
      color:#2d2a35;
      min-height:100vh;
      padding:20px;
    }

    /* ======= ATM CARD ======= */
    .atm-card {
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      border-radius:20px;
      padding:25px;
      color:#fff;
      box-shadow:0 8px 25px rgba(94,75,255,.3);
      max-width:420px;
      margin:0 auto 40px;
      position:relative;
      overflow:hidden;
    }
    .atm-card::before {
      content:"";
      position:absolute;
      top:-40px; right:-40px;
      width:150px; height:150px;
      background:rgba(255,255,255,.15);
      border-radius:50%;
    }
    .atm-header {display:flex;justify-content:space-between;align-items:center;}
    .atm-header h2 {font-size:16px;font-weight:600;letter-spacing:1px;}
    .atm-balance {font-size:34px;font-weight:700;margin:25px 0;}
    .atm-footer {display:flex;justify-content:space-between;font-size:14px;opacity:.9;}

      /* ======= GRID SECTION ======= */
    .grid-boxes {
      display:grid;
      grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
      gap:15px;
      max-width:800px;
      margin:30px auto;
    }
    .grid-item {
        background: #fff;
        border-radius: 18px;
        padding: 25px 20px;
        text-align: center;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .grid-item:hover { transform:translateY(-5px); }
    .grid-item i { font-size:26px; margin-bottom:10px; color:#9D4EDD; }
    .grid-item h4 { font-size:15px; margin-bottom:5px; }
    .grid-item p { font-size:18px; font-weight:600; }


    /* ======= REFERRAL ======= */
    .referral {
      background:#fff;
      border-radius:16px;
      max-width:1000px;
      margin:0 auto;
      padding:20px;
      box-shadow:0 6px 18px rgba(0,0,0,.08);
    }
    .referral h3 {margin-bottom:15px;color:#2d2a35;}
    .ref-box {
      background:#f1edff;
      border-radius:12px;
      padding:12px 15px;
      display:flex;
      justify-content:space-between;
      align-items:center;
      flex-wrap:wrap;
      word-break:break-all;
    }
    .copy-btn {
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      border:none;
      color:#fff;
      padding:8px 14px;
      border-radius:8px;
      cursor:pointer;
      margin-top:10px;
      transition:background .3s;
    }
    .copy-btn:hover {background:linear-gradient(135deg,#4e3ce6,#7a59ff);}

    @media (max-width:500px){
      .atm-balance {font-size:28px;}
      .stat-box p {font-size:18px;}
    }
  </style>
</head>
<body>

  <!-- Top ATM-style Balance Card -->
  <section class="atm-card">
    <div class="atm-header">
      <h2>Total Balance</h2>
      <i class="fa-solid fa-wifi"></i>
    </div>
    <div class="atm-balance">₦50,000.00</div><!-- Replace with PHP variable -->
    <div class="atm-footer">
      <span>John Doe</span>
      <span>Premium User</span>
    </div>
  </section>

  <!-- Four Boxes in a Responsive Grid -->
  <section class="grid-boxes">
    <div class="grid-item">
      <i class="fa-solid fa-handshake"></i>
      <h4>Affiliate</h4>
      <p>₦10,000</p>
    </div>
    <div class="grid-item">
      <i class="fa-solid fa-tasks"></i>
      <h4>Task</h4>
      <p>₦5,000</p>
    </div>
    <div class="grid-item">
      <i class="fa-solid fa-users"></i>
      <h4>Total Referrals</h4>
      <p>120</p>
    </div>
    <div class="grid-item">
      <i class="fa-solid fa-wallet"></i>
      <h4>Total Earnings</h4>
      <p>₦65,000</p>
    </div>
  </section>

  <!-- Referral Section -->
  <section class="referral">
    <h3>Your Referral Link</h3>
    <div class="ref-box">
      <span id="refLink">https://example.com/signup?ref=johndoe</span>
      <button class="copy-btn" onclick="copyReferral()">Copy</button>
    </div>
  </section>

  <script>
    function copyReferral(){
      const link=document.getElementById('refLink').innerText;
      navigator.clipboard.writeText(link).then(()=>{
        alert('Referral link copied!');
      });
    }
  </script>
</body>
</html>