<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Header</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}

  /* ===== HEADER ===== */
  .user-header{
    position:sticky;      /* stays at top on scroll */
    top:0;
    width:100%;
    background:#fff;
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:12px 20px;
    box-shadow:0 4px 10px rgba(0,0,0,0.08);
    z-index:50;
  }

  .user-info{
    display:flex;
    align-items:center;
    gap:12px;
  }

  .user-info img{
    width:40px;
    height:40px;
    border-radius:50%;
    object-fit:cover;
    border:2px solid #5e4bff;  /* purple ring */
  }

  .user-info .name{
    font-weight:600;
    color:#2d2a35;
    font-size:16px;
  }

  .menu-btn{
    background:none;
    border:none;
    font-size:22px;
    color:#5e4bff;
    cursor:pointer;
  }

  /* Optional: Adjust on small screens */
  @media (max-width:480px){
    .user-info .name{font-size:14px;}
  }
</style>
</head>
<body>

<!-- Header Start -->
<header class="user-header">
  <div class="user-info">
    <!-- Replace the src with the user's actual profile image -->
    <img src="https://via.placeholder.com/80x80.png?text=U" alt="Profile Picture" id="profilePic">
    <span class="name" id="userName">John Doe</span>
  </div>
  <!-- Menu / settings icon -->
  <button class="menu-btn" aria-label="Open menu"><i class="fa-solid fa-bars"></i></button>
</header>
<!-- Header End -->

<main style="padding:20px;">
  <h1>Page Content</h1>
  <p>This is where your page content goes. The header stays on top.</p>
</main>

<script>
  // Example of dynamically updating from backend data:
  // document.getElementById('userName').textContent = currentUser.name;
  // document.getElementById('profilePic').src = currentUser.profile_image_url;
</script>
</body>
</html>