<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Footer Navigation</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    min-height:100vh;
    display:flex;
    flex-direction:column;
    justify-content:space-between;
    background:#f5f3fa;
  }

  /* ===== FOOTER BAR ===== */
  .footer-nav{
    position:fixed;
    bottom:0;
    left:0;
    width:100%;
    background:#fff;
    display:flex;
    justify-content:space-around;
    align-items:center;
    padding:10px 0;
    box-shadow:0 -4px 14px rgba(0,0,0,0.08);
    z-index:10;
  }

  .footer-nav a,
  .footer-nav button{
    color:#5e4bff;
    text-decoration:none;
    text-align:center;
    background:none;
    border:none;
    cursor:pointer;
    font-size:14px;
    display:flex;
    flex-direction:column;
    align-items:center;
    gap:4px;
  }
  .footer-nav i{
    font-size:20px;
  }

  /* ===== SLIDE-UP MENU ===== */
  .nav-overlay{
    position:fixed;
    inset:0;
    background:rgba(0,0,0,0.4);
    display:none;
    z-index:20;
  }
  .nav-menu{
    position:fixed;
    bottom:-60%;
    left:0;
    width:100%;
    background:#fff;
    border-top-left-radius:20px;
    border-top-right-radius:20px;
    box-shadow:0 -4px 20px rgba(0,0,0,.25);
    padding:25px 20px;
    transition:bottom .3s ease;
    z-index:21;
  }
  .nav-menu.active{bottom:0;}
  .nav-overlay.active{display:block;}

  .nav-menu h3{
    text-align:center;
    color:#5e4bff;
    margin-bottom:20px;
  }

  .nav-links{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(140px,1fr));
    gap:15px;
  }
  .nav-links a{
    background:#f1edff;
    border-radius:12px;
    padding:12px;
    text-align:center;
    text-decoration:none;
    color:#2d2a35;
    font-weight:600;
    transition:background .3s;
  }
  .nav-links a:hover{
    background:#e0d7ff;
  }
</style>
</head>
<body>

<main style="padding:40px;text-align:center;">
  <h1>Page Content Here</h1>
  <p>Scroll down to see the footer navigation bar fixed at the bottom.</p>
</main>

<!-- Footer Bar -->
<footer class="footer-nav">
  <a href="home.html"><i class="fa-solid fa-house"></i><span>Home</span></a>
  <a href="profile.html"><i class="fa-solid fa-user"></i><span>Profile</span></a>
  <a href="history.html"><i class="fa-solid fa-clock-rotate-left"></i><span>History</span></a>
  <button id="menuBtn"><i class="fa-solid fa-bars"></i><span>Menu</span></button>
</footer>

<!-- Slide-up Menu -->
<div class="nav-overlay" id="navOverlay"></div>
<div class="nav-menu" id="navMenu">
  <h3>Quick Navigation</h3>
  <div class="nav-links">
    <a href="tasks.html">Tasks</a>
    <a href="marketplace.html">Marketplace</a>
    <a href="withdrawals.html">Withdrawals</a>
    <a href="vendor.html">Vendors</a>
    <a href="quizzes.html">Quizzes</a>
    <a href="channels.html">Channels</a>
    <!-- Add more links as needed -->
  </div>
</div>

<script>
  const menuBtn = document.getElementById('menuBtn');
  const navMenu = document.getElementById('navMenu');
  const navOverlay = document.getElementById('navOverlay');

  menuBtn.addEventListener('click', () => {
    navMenu.classList.toggle('active');
    navOverlay.classList.toggle('active');
  });
  navOverlay.addEventListener('click', () => {
    navMenu.classList.remove('active');
    navOverlay.classList.remove('active');
  });
</script>
</body>
</html>