<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Transaction History</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    padding:20px;
    min-height:100vh;
  }

  h1{
    text-align:center;
    margin-bottom:30px;
    color:#4b3cbf;
    font-weight:600;
  }

  /* ===== SUMMARY GRID ===== */
  .summary-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(170px,1fr));
    gap:15px;
    max-width:1000px;
    margin:0 auto 40px;
  }
  .summary-card{
    background:#fff;
    border-radius:16px;
    padding:20px;
    text-align:center;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
    transition:transform .2s;
  }
  .summary-card:hover{transform:translateY(-5px);}
  .summary-card i{
    font-size:28px;
    margin-bottom:10px;
    color:#9D4EDD;
  }
  .summary-card h3{
    font-size:16px;
    margin-bottom:4px;
  }
  .summary-card p{
    font-size:20px;
    font-weight:700;
    color:#4b3cbf;
  }

  /* ===== FILTER BAR ===== */
  .filter-bar{
    max-width:1000px;
    margin:0 auto 20px;
    display:flex;
    flex-wrap:wrap;
    gap:10px;
    justify-content:space-between;
    align-items:center;
  }
  .filter-bar select, .filter-bar input{
    padding:8px 12px;
    border:1px solid #ccc;
    border-radius:8px;
    font-size:14px;
  }

  /* ===== TABLE ===== */
  .table-wrapper{
    max-width:1000px;
    margin:0 auto;
    overflow-x:auto;
    background:#fff;
    border-radius:16px;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
  }
  table{
    width:100%;
    border-collapse:collapse;
    min-width:700px;
  }
  thead{
    background:#9D4EDD;
    color:#fff;
  }
  th, td{
    padding:14px 12px;
    text-align:left;
    font-size:14px;
  }
  tbody tr:nth-child(even){
    background:#f5f3fa;
  }

  /* Status tags */
  .status{
    padding:4px 10px;
    border-radius:12px;
    font-weight:600;
    font-size:13px;
    display:inline-block;
  }
  .status.success{background:#e3ffe3;color:#2e7d32;}
  .status.failed{background:#ffe3e3;color:#c62828;}
  .status.pending{background:#fff3cd;color:#b38300;}

  @media(max-width:600px){
    th, td{font-size:13px;padding:10px;}
  }
</style>
</head>
<body>

<h1>Transaction History</h1>

<!-- Summary boxes -->
<section class="summary-grid">
  <div class="summary-card">
    <i class="fa-solid fa-wallet"></i>
    <h3>Total Deposits</h3>
    <p>₦120,000</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-money-bill-trend-up"></i>
    <h3>Total Withdrawals</h3>
    <p>₦60,000</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-sim-card"></i>
    <h3>Airtime/Data Purchases</h3>
    <p>₦25,000</p>
  </div>
  <div class="summary-card">
    <i class="fa-solid fa-handshake"></i>
    <h3>Other Transactions</h3>
    <p>₦10,000</p>
  </div>
</section>

<!-- Filter bar -->
<div class="filter-bar">
  <select id="typeFilter">
    <option value="">All Types</option>
    <option value="deposit">Deposit</option>
    <option value="withdrawal">Withdrawal</option>
    <option value="airtime">Airtime</option>
    <option value="data">Data</option>
  </select>
  <input type="date" id="dateFilter">
</div>

<!-- Transactions table -->
<div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <th>Date</th>
        <th>Type</th>
        <th>Amount (₦)</th>
        <th>Description</th>
        <th>Status</th>
      </tr>
    </thead>
    <tbody id="historyBody">
      <!-- Replace these rows with dynamic PHP/JS -->
      <tr>
        <td>2025-09-15</td>
        <td>Deposit</td>
        <td>20,000</td>
        <td>Bank Transfer</td>
        <td><span class="status success">Success</span></td>
      </tr>
      <tr>
        <td>2025-09-14</td>
        <td>Airtime</td>
        <td>1,500</td>
        <td>MTN Recharge</td>
        <td><span class="status success">Success</span></td>
      </tr>
      <tr>
        <td>2025-09-13</td>
        <td>Withdrawal</td>
        <td>10,000</td>
        <td>Bank Payout</td>
        <td><span class="status pending">Pending</span></td>
      </tr>
      <tr>
        <td>2025-09-11</td>
        <td>Data</td>
        <td>2,000</td>
        <td>Glo 2GB</td>
        <td><span class="status failed">Failed</span></td>
      </tr>
    </tbody>
  </table>
</div>

<script>
  // Example client-side filter logic
  const typeFilter=document.getElementById('typeFilter');
  const dateFilter=document.getElementById('dateFilter');
  const historyBody=document.getElementById('historyBody');

  typeFilter.addEventListener('change',filterRows);
  dateFilter.addEventListener('change',filterRows);

  function filterRows(){
    const typeVal=typeFilter.value.toLowerCase();
    const dateVal=dateFilter.value;
    [...historyBody.rows].forEach(row=>{
      const type=row.cells[1].innerText.toLowerCase();
      const date=row.cells[0].innerText;
      let show=true;
      if(typeVal && !type.includes(typeVal)) show=false;
      if(dateVal && !date.includes(dateVal)) show=false;
      row.style.display=show?'':'none';
    });
  }
</script>

</body>
</html>