<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Buy Data</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    min-height:100vh;
    padding:20px;
  }
  h1{
    text-align:center;
    margin-bottom:30px;
    color:#4b3cbf;
    font-weight:600;
  }

  .data-form{
    max-width:420px;
    background:#fff;
    margin:0 auto;
    padding:25px 30px;
    border-radius:18px;
    box-shadow:0 8px 20px rgba(0,0,0,.08);
  }

  label{
    display:block;
    margin-bottom:8px;
    font-size:14px;
    font-weight:600;
    color:#4b3cbf;
  }
  input, select{
    width:100%;
    padding:12px;
    margin-bottom:20px;
    border:1px solid #ccc;
    border-radius:10px;
    font-size:15px;
    transition:border-color .2s;
  }
  input:focus, select:focus{
    outline:none;
    border-color:#9D4EDD;
    box-shadow:0 0 0 3px rgba(157,78,221,.2);
  }

  button[type="submit"]{
    width:100%;
    padding:14px;
    background:linear-gradient(135deg,#5e4bff,#8a66ff);
    color:#fff;
    font-size:16px;
    border:none;
    border-radius:10px;
    cursor:pointer;
    transition:background .3s;
  }
  button[type="submit"]:hover{
    background:linear-gradient(135deg,#4e3ce6,#7a59ff);
  }

  .note{
    font-size:13px;
    color:#666;
    margin-top:10px;
    text-align:center;
  }
</style>
</head>
<body>

<h1>Buy Data</h1>

<form class="data-form" id="dataForm" action="process_data.php" method="POST">
  <!-- Network -->
  <label for="network">Network</label>
  <select name="network" id="network" required>
    <option value="">Select Network</option>
    <option value="MTN">MTN</option>
    <option value="Airtel">Airtel</option>
    <option value="Glo">Glo</option>
    <option value="9mobile">9mobile</option>
  </select>

  <!-- Data Plan -->
  <label for="plan">Data Plan</label>
  <select name="plan" id="plan" required>
    <option value="">Select Plan</option>
    <!-- Example placeholder plans. Replace with dynamic values from DB/API -->
    <option value="500MB-500">500 MB – ₦500</option>
    <option value="1GB-1000">1 GB – ₦1,000</option>
    <option value="2GB-1800">2 GB – ₦1,800</option>
    <option value="5GB-3500">5 GB – ₦3,500</option>
  </select>

  <!-- Phone Number -->
  <label for="phone">Recipient Number</label>
  <input type="tel" name="phone" id="phone" placeholder="e.g. 08012345678" pattern="[0-9]{11}" required>

  <button type="submit">Purchase Data</button>
  <p class="note">Prices are examples. Update with live plans &amp; pricing.</p>
</form>

<script>
  document.getElementById('dataForm').addEventListener('submit', function(e){
    e.preventDefault();
    const network = document.getElementById('network').value;
    const plan    = document.getElementById('plan').value;
    const phone   = document.getElementById('phone').value;

    if(!network || !plan || !phone) return;

    const [planName, price] = plan.split('-');

    Swal.fire({
      title: 'Confirm Purchase',
      html: `Network: <b>${network}</b><br>Plan: <b>${planName}</b><br>Price: <b>₦${price}</b><br>Phone: <b>${phone}</b>`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonText: 'Yes, Buy Now',
      cancelButtonText: 'Cancel',
      confirmButtonColor: '#5e4bff'
    }).then((result)=>{
      if(result.isConfirmed){
        this.submit(); // proceed with form submission
      }
    });
  });
</script>

</body>
</html>