<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Digital Courses</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    min-height:100vh;
    padding:20px;
  }
  h1{
    text-align:center;
    margin-bottom:30px;
    color:#4b3cbf;
    font-weight:600;
  }

  /* ======= COURSES GRID ======= */
  .courses-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
    gap:20px;
    max-width:1200px;
    margin:0 auto;
  }

  .course-card{
    background:#fff;
    border-radius:18px;
    box-shadow:0 8px 20px rgba(0,0,0,.08);
    overflow:hidden;
    display:flex;
    flex-direction:column;
    transition:transform .2s, box-shadow .2s;
  }
  .course-card:hover{
    transform:translateY(-6px);
    box-shadow:0 12px 28px rgba(0,0,0,.12);
  }

  .course-img{
    width:100%;
    height:160px;
    object-fit:cover;
  }

  .course-content{
    padding:18px;
    flex:1;
    display:flex;
    flex-direction:column;
    justify-content:space-between;
  }

  .course-title{
    font-size:18px;
    font-weight:600;
    margin-bottom:10px;
    color:#2d2a35;
  }
  .course-desc{
    font-size:14px;
    color:#555;
    margin-bottom:15px;
    line-height:1.4;
  }
  .course-price{
    font-size:16px;
    font-weight:600;
    color:#4b3cbf;
    margin-bottom:15px;
  }
  .enroll-btn{
    background:linear-gradient(135deg,#5e4bff,#8a66ff);
    border:none;
    color:#fff;
    padding:10px 16px;
    border-radius:10px;
    font-size:14px;
    cursor:pointer;
    transition:background .3s;
  }
  .enroll-btn:hover{
    background:linear-gradient(135deg,#4e3ce6,#7a59ff);
  }
</style>
</head>
<body>

<h1>Digital Courses</h1>

<section class="courses-grid">

  <!-- Single Course Card -->
  <div class="course-card">
    <img src="https://source.unsplash.com/400x200/?programming" alt="Programming" class="course-img">
    <div class="course-content">
      <div>
        <h2 class="course-title">Full-Stack Web Development</h2>
        <p class="course-desc">Learn HTML, CSS, JavaScript, PHP and build complete web applications from scratch.</p>
      </div>
      <div>
        <div class="course-price">₦20,000</div>
        <button class="enroll-btn" onclick="enroll('Full-Stack Web Development')">Enroll Now</button>
      </div>
    </div>
  </div>

  <div class="course-card">
    <img src="https://source.unsplash.com/400x200/?design" alt="UI/UX" class="course-img">
    <div class="course-content">
      <div>
        <h2 class="course-title">UI/UX Design Fundamentals</h2>
        <p class="course-desc">Master wireframing, prototyping and modern design tools for user-friendly interfaces.</p>
      </div>
      <div>
        <div class="course-price">₦15,000</div>
        <button class="enroll-btn" onclick="enroll('UI/UX Design Fundamentals')">Enroll Now</button>
      </div>
    </div>
  </div>

  <div class="course-card">
    <img src="https://source.unsplash.com/400x200/?marketing" alt="Digital Marketing" class="course-img">
    <div class="course-content">
      <div>
        <h2 class="course-title">Digital Marketing Mastery</h2>
        <p class="course-desc">SEO, social media, and advertising strategies to grow any business online.</p>
      </div>
      <div>
        <div class="course-price">₦12,500</div>
        <button class="enroll-btn" onclick="enroll('Digital Marketing Mastery')">Enroll Now</button>
      </div>
    </div>
  </div>

  <!-- Add more course-card blocks as needed -->

</section>

<script>
function enroll(courseName){
  alert('You selected the course: ' + courseName + '\nRedirecting to payment/enrollment page...');
  // Replace with a redirect or modal for actual enrollment
}
</script>

</body>
</html>