<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Bind Bank Account</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <style>
    *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
    body{
      background:#f5f3fa;
      min-height:100vh;
      padding:20px;
      color:#2d2a35;
    }

    .bank-container{
      max-width:450px;
      margin:40px auto;
      background:#fff;
      border-radius:20px;
      padding:30px 25px;
      box-shadow:0 8px 25px rgba(0,0,0,0.08);
    }

    h1{
      text-align:center;
      font-size:22px;
      font-weight:600;
      margin-bottom:25px;
      color:#4b3cbf;
    }

    label{
      display:block;
      margin-bottom:6px;
      font-weight:600;
      font-size:15px;
      color:#2d2a35;
    }

    input, select{
      width:100%;
      padding:12px 14px;
      margin-bottom:18px;
      border:1px solid #ccc;
      border-radius:10px;
      font-size:15px;
      transition:border-color .2s;
    }
    input:focus, select:focus{
      border-color:#9D4EDD;
      outline:none;
    }

    .submit-btn{
      width:100%;
      background:linear-gradient(135deg,#5e4bff,#8a66ff);
      color:#fff;
      border:none;
      padding:12px 0;
      border-radius:12px;
      font-size:16px;
      font-weight:600;
      cursor:pointer;
      transition:background .3s;
    }
    .submit-btn:hover{
      background:linear-gradient(135deg,#4e3ce6,#7a59ff);
    }

    .note{
      font-size:13px;
      color:#555;
      text-align:center;
      margin-top:15px;
      line-height:1.4;
    }
  </style>
</head>
<body>

  <div class="bank-container">
    <h1><i class="fa-solid fa-building-columns"></i> Bind Bank Account</h1>

    <form action="bind_bank.php" method="POST">
      <!-- Full Name -->
      <label for="account_name">Account Name</label>
      <input type="text" id="account_name" name="account_name" placeholder="Exact name on bank account" required>

      <!-- Bank Name -->
      <label for="bank_name">Bank Name</label>
      <select id="bank_name" name="bank_name" required>
        <option value="" disabled selected>-- Select Bank --</option>
        <option value="Access Bank">Access Bank</option>
        <option value="First Bank">First Bank</option>
        <option value="GTBank">GTBank</option>
        <option value="UBA">UBA</option>
        <option value="Zenith Bank">Zenith Bank</option>
        <!-- Add more Nigerian banks as needed -->
      </select>

      <!-- Account Number -->
      <label for="account_number">Account Number</label>
      <input type="number" id="account_number" name="account_number" placeholder="10-digit account number" pattern="\d{10}" required>

      <!-- Optional BVN for verification -->
      <label for="bvn">BVN (Optional)</label>
      <input type="number" id="bvn" name="bvn" placeholder="11-digit BVN" pattern="\d{11}">

      <button type="submit" class="submit-btn">Save Bank Details</button>

      <p class="note">
        Your bank information is securely stored and used only for withdrawals.  
        Make sure details match your real bank account to avoid failed payouts.
      </p>
    </form>
  </div>

</body>
</html>