<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Buy Airtime</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
  *{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
  body{
    background:#f5f3fa;
    color:#2d2a35;
    min-height:100vh;
    padding:20px;
  }
  h1{
    text-align:center;
    margin-bottom:30px;
    color:#4b3cbf;
    font-weight:600;
  }

  .airtime-form{
    max-width:400px;
    background:#fff;
    margin:0 auto;
    padding:25px 30px;
    border-radius:18px;
    box-shadow:0 8px 20px rgba(0,0,0,.08);
  }

  label{
    display:block;
    margin-bottom:8px;
    font-size:14px;
    font-weight:600;
    color:#4b3cbf;
  }
  input, select{
    width:100%;
    padding:12px;
    margin-bottom:20px;
    border:1px solid #ccc;
    border-radius:10px;
    font-size:15px;
    transition:border-color .2s;
  }
  input:focus, select:focus{
    outline:none;
    border-color:#9D4EDD;
    box-shadow:0 0 0 3px rgba(157,78,221,.2);
  }

  .quick-amounts{
    display:flex;
    flex-wrap:wrap;
    gap:10px;
    margin-bottom:20px;
  }
  .quick-amounts button{
    flex:1 1 30%;
    background:#f5f3fa;
    border:none;
    padding:10px 0;
    border-radius:10px;
    cursor:pointer;
    color:#4b3cbf;
    font-weight:600;
    transition:background .2s;
  }
  .quick-amounts button:hover{
    background:#e3d9ff;
  }

  button[type="submit"]{
    width:100%;
    padding:14px;
    background:linear-gradient(135deg,#5e4bff,#8a66ff);
    color:#fff;
    font-size:16px;
    border:none;
    border-radius:10px;
    cursor:pointer;
    transition:background .3s;
  }
  button[type="submit"]:hover{
    background:linear-gradient(135deg,#4e3ce6,#7a59ff);
  }

  .note{
    font-size:13px;
    color:#666;
    margin-top:10px;
    text-align:center;
  }
</style>
</head>
<body>

<h1>Buy Airtime</h1>

<form class="airtime-form" id="airtimeForm" action="process_airtime.php" method="POST">
  <!-- Network -->
  <label for="network">Network</label>
  <select name="network" id="network" required>
    <option value="">Select Network</option>
    <option value="MTN">MTN</option>
    <option value="Airtel">Airtel</option>
    <option value="Glo">Glo</option>
    <option value="9mobile">9mobile</option>
  </select>

  <!-- Phone Number -->
  <label for="phone">Phone Number</label>
  <input type="tel" name="phone" id="phone" placeholder="e.g. 08012345678" pattern="[0-9]{11}" required>

  <!-- Amount -->
  <label for="amount">Amount (₦)</label>
  <input type="number" name="amount" id="amount" placeholder="Enter amount" min="50" required>

  <!-- Quick Amount Buttons -->
  <div class="quick-amounts">
    <button type="button" data-amt="100">₦100</button>
    <button type="button" data-amt="200">₦200</button>
    <button type="button" data-amt="500">₦500</button>
    <button type="button" data-amt="1000">₦1000</button>
  </div>

  <button type="submit">Purchase Airtime</button>
  <p class="note">A service charge may apply depending on your payment method.</p>
</form>

<script>
  // Quick amount buttons
  document.querySelectorAll('.quick-amounts button').forEach(btn=>{
    btn.addEventListener('click',()=>{
      document.getElementById('amount').value = btn.dataset.amt;
    });
  });
</script>

</body>
</html>