<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Withdrawals – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.main h1{margin-bottom:20px;}
.controls{
  display:flex;flex-wrap:wrap;justify-content:space-between;align-items:center;
  margin-bottom:15px;gap:10px;
}
.controls input[type="search"]{
  padding:8px 12px;border:1px solid #ccc;border-radius:8px;font-size:14px;
  width:220px;
}
.controls select{
  padding:8px 12px;border:1px solid #ccc;border-radius:8px;font-size:14px;
}

/* ===== TABLE ===== */
.table-container{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  overflow-x:auto;
}
table{width:100%;border-collapse:collapse;min-width:850px;}
th,td{padding:14px 16px;text-align:left;border-bottom:1px solid #eee;font-size:15px;}
th{background:#f1effa;font-weight:600;}
.action-btn{
  padding:6px 12px;border:none;border-radius:6px;cursor:pointer;font-size:14px;
  color:#fff;margin-right:6px;transition:opacity .2s;
}
.approve-btn{background:#2ecc71;}
.decline-btn{background:#e74c3c;}
.action-btn:hover{opacity:.85;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <button class="subnav-btn"><i class="fa-solid fa-wallet"></i> Finance <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">Withdrawals</a>
    <a href="#">Deposits</a>
  </div>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main">
  <h1>Withdrawals</h1>
  <div class="controls">
    <div>
      Show
      <select id="entriesSelect">
        <option value="5">5</option>
        <option value="10" selected>10</option>
        <option value="25">25</option>
      </select>
      entries
    </div>
    <input type="search" id="searchInput" placeholder="Search withdrawals...">
  </div>

  <div class="table-container">
    <table id="withdrawalsTable">
      <thead>
        <tr>
          <th>#ID</th>
          <th>User</th>
          <th>Amount</th>
          <th>Wallet</th>
          <th>Date</th>
          <th>Status</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
        <!-- Example rows -->
        <tr>
          <td>1001</td>
          <td>Jane Doe</td>
          <td>₦20,000</td>
          <td>Main Wallet</td>
          <td>2025-09-16</td>
          <td>Pending</td>
          <td>
            <button class="action-btn approve-btn">Approve</button>
            <button class="action-btn decline-btn">Decline</button>
          </td>
        </tr>
        <tr>
          <td>1002</td>
          <td>John Smith</td>
          <td>₦5,000</td>
          <td>Bonus Wallet</td>
          <td>2025-09-16</td>
          <td>Pending</td>
          <td>
            <button class="action-btn approve-btn">Approve</button>
            <button class="action-btn decline-btn">Decline</button>
          </td>
        </tr>
        <!-- Add more rows dynamically from backend -->
      </tbody>
    </table>
  </div>
</main>

<script>
// Sidebar toggle
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

// Approve / Decline actions
document.querySelectorAll('.approve-btn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    if(confirm('Approve this withdrawal?')){
      alert('Withdrawal approved (demo only).');
      // TODO: call backend API
    }
  });
});
document.querySelectorAll('.decline-btn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    if(confirm('Decline this withdrawal?')){
      alert('Withdrawal declined (demo only).');
      // TODO: call backend API
    }
  });
});

// Simple search filter
const searchInput=document.getElementById('searchInput');
searchInput.addEventListener('keyup',()=>{
  const filter=searchInput.value.toLowerCase();
  document.querySelectorAll('#withdrawalsTable tbody tr').forEach(row=>{
    row.style.display=row.textContent.toLowerCase().includes(filter)?'':'none';
  });
});

// Show entries (front-end only demo)
document.getElementById('entriesSelect').addEventListener('change',e=>{
  const max=parseInt(e.target.value);
  const rows=[...document.querySelectorAll('#withdrawalsTable tbody tr')];
  rows.forEach((row,i)=>row.style.display = i<max ? '' : 'none');
});
// initialize default
document.getElementById('entriesSelect').dispatchEvent(new Event('change'));
</script>

</body>
</html>