<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Details – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.user-card{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  padding:30px;max-width:700px;margin:auto;
}
.user-header{display:flex;align-items:center;gap:20px;margin-bottom:25px;}
.user-header img{width:80px;height:80px;border-radius:50%;border:3px solid #6b4bff;object-fit:cover;}
.user-header h2{margin:0;font-size:22px;}

/* ===== FORM ===== */
.user-form label{display:block;margin-top:15px;font-weight:600;font-size:14px;}
.user-form input, .user-form select{
  width:100%;padding:10px 12px;margin-top:5px;border:1px solid #ccc;
  border-radius:8px;font-size:15px;
}
.user-form input:focus{outline:none;border-color:#6b4bff;box-shadow:0 0 0 2px rgba(107,75,255,0.2);}
.save-btn{
  margin-top:25px;background:#6b4bff;color:#fff;border:none;
  padding:12px 20px;font-size:15px;border-radius:8px;cursor:pointer;
}
.save-btn:hover{opacity:0.9;}

.actions{
  margin-top:30px;display:flex;flex-wrap:wrap;gap:15px;
}
.action-btn{
  padding:10px 20px;border:none;border-radius:6px;cursor:pointer;font-size:15px;
  color:#fff;transition:opacity .2s;
}
.delete-btn{background:#e74c3c;}
.api-btn{background:#6b4bff;}
.action-btn:hover{opacity:.85;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <a href="#"><i class="fa-solid fa-wallet"></i> Finance</a>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main" id="main">
  <div class="user-card">
    <div class="user-header">
      <img src="https://via.placeholder.com/80x80.png?text=U" alt="User Photo">
      <div>
        <h2>Edit User</h2>
        <p>Status: <span id="statusText">Active</span></p>
      </div>
    </div>

    <form class="user-form" id="userForm">
      <label>Full Name
        <input type="text" id="fullName" value="Jane Doe">
      </label>
      <label>Email
        <input type="email" id="email" value="jane@example.com">
      </label>
      <label>Username
        <input type="text" id="username" value="jane_d">
      </label>
      <label>Joined Date
        <input type="text" id="joined" value="2025-02-14" readonly>
      </label>
      <label>Last Login
        <input type="text" id="lastLogin" value="2025-09-15" readonly>
      </label>
      <label>Status
        <select id="status">
          <option value="active" selected>Active</option>
          <option value="banned">Banned</option>
        </select>
      </label>
      <button type="submit" class="save-btn">Save Changes</button>
    </form>

    <div class="actions">
      <button class="action-btn delete-btn" id="deleteBtn"><i class="fa-solid fa-trash"></i> Delete Account</button>
      <button class="action-btn api-btn" id="apiBtn"><i class="fa-solid fa-key"></i> Generate API Key</button>
    </div>
  </div>
</main>

<script>
// Sidebar toggle
document.getElementById('menuBtn').onclick=()=>document.getElementById('sidebar').classList.toggle('show');
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.onclick=()=>btn.nextElementSibling.classList.toggle('show'));

// Save handler
document.getElementById('userForm').addEventListener('submit',e=>{
  e.preventDefault();
  // TODO: send updated values to backend
  alert("User information saved (demo only).");
});

// Delete confirmation
document.getElementById('deleteBtn').onclick=()=>{
  if(confirm("⚠️ Deleting this account is permanent. Continue?")){
    // TODO: backend delete
    alert("User deleted (demo only).");
  }
};

// Generate API Key
document.getElementById('apiBtn').onclick=()=>{
  if(confirm("⚠️ Generating a new API key will invalidate any old keys. Proceed?")){
    const newKey='api_'+Math.random().toString(36).slice(2,12);
    alert("New API Key generated (demo): "+newKey);
  }
};
</script>

</body>
</html>