<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Approve Tasks – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}
.header{position:fixed;top:0;left:0;width:100%;height:60px;background:#fff;display:flex;justify-content:space-between;align-items:center;padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}
.sidebar{width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;}
.sidebar a,.sidebar button.subnav-btn{color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;text-decoration:none;background:none;border:none;width:100%;text-align:left;cursor:pointer;font-size:15px;}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}
.main{padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;overflow-x:hidden;}

/* Top bar & controls */
.top-bar{display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap;margin-bottom:20px;gap:10px;}
.top-bar .entries{display:flex;align-items:center;gap:6px;}
.entries select{padding:6px 8px;border-radius:6px;border:1px solid #ccc;font-size:14px;}
.search-input{padding:8px 14px;border:1px solid #ccc;border-radius:6px;width:250px;max-width:100%;}

/* Table */
.table-wrapper {
  width: 100%;
  overflow-x: auto;  /* enables horizontal scroll if content overflows */
  -webkit-overflow-scrolling: touch; /* smooth scrolling on iOS */
}
.tasks-table {
  min-width: 800px; /* force table to be wider than screen if needed */
}
.tasks-table{width:100%;border-collapse:collapse;background:#fff;border-radius:10px;overflow:hidden;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
.tasks-table th, .tasks-table td{padding:12px 10px;text-align:left;border-bottom:1px solid #eee;font-size:14px;}
.tasks-table th{background:#6b4bff;color:#fff;font-weight:600;}
.action-btn{padding:6px 12px;margin:0 2px;border:none;border-radius:6px;font-size:13px;cursor:pointer;color:#fff;}
.approve-btn{background:#27ae60;}
.decline-btn{background:#e74c3c;}
.view-btn{background:#3498db;}
.action-btn:hover{opacity:0.85;}

/* Modal */
.modal{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);display:none;justify-content:center;align-items:center;overflow-y:auto;z-index:2000;padding:20px;}
.modal-content{background:#fff;border-radius:10px;max-width:600px;width:100%;padding:20px;position:relative;max-height:90vh;overflow-y:auto;}
.modal-content h2{margin-bottom:15px;}
.close-btn{position:absolute;top:12px;right:12px;font-size:20px;cursor:pointer;color:#333;}
.form-group{margin-bottom:12px;}
.form-group label{display:block;margin-bottom:4px;font-weight:600;}
.form-group input,.form-group textarea{width:100%;padding:8px 10px;border:1px solid #ccc;border-radius:6px;font-size:14px;}
.form-group textarea{resize:vertical;min-height:60px;}
.modal-actions{margin-top:20px;display:flex;flex-wrap:wrap;gap:10px;}
.save-btn{background:#6b4bff;color:#fff;border:none;border-radius:6px;padding:8px 14px;cursor:pointer;}

/* Responsive */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-briefcase"></i> Tasks <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">Approve Tasks</a>
    <a href="#">All Tasks</a>
  </div>
  <a href="#"><i class="fa-solid fa-users"></i> Users</a>
</nav>

<main class="main">
  <div class="top-bar">
    <div class="entries">
      <label for="entriesSelect">Show</label>
      <select id="entriesSelect">
        <option value="5">5</option>
        <option value="10" selected>10</option>
        <option value="20">20</option>
      </select>
      <span>entries</span>
    </div>
    <input type="text" class="search-input" id="searchInput" placeholder="Search tasks...">
  </div>

<div class="table-wrapper">
  <table class="tasks-table" id="tasksTable">
    <thead>
      <tr><th>#</th><th>User</th><th>Task</th><th>Date Submitted</th><th>Actions</th></tr>
    </thead>
    <tbody id="taskBody">
      <tr>
        <td>1</td><td>Jane Doe</td><td>Instagram Follow</td><td>2025-09-16</td>
        <td>
          <button class="action-btn view-btn" onclick="openModal(1)">View</button>
          <button class="action-btn approve-btn" onclick="approveTask(1)">Approve</button>
          <button class="action-btn decline-btn" onclick="declineTask(1)">Decline</button>
        </td>
      </tr>
      <tr>
        <td>2</td><td>John Smith</td><td>Facebook Like</td><td>2025-09-15</td>
        <td>
          <button class="action-btn view-btn" onclick="openModal(2)">View</button>
          <button class="action-btn approve-btn" onclick="approveTask(2)">Approve</button>
          <button class="action-btn decline-btn" onclick="declineTask(2)">Decline</button>
        </td>
      </tr>
    </tbody>
  </table>
</div>
</main>

<!-- Modal -->
<div class="modal" id="taskModal">
  <div class="modal-content">
    <span class="close-btn" onclick="closeModal()">&times;</span>
    <h2>Edit & Approve Task</h2>
    <form id="taskForm">
      <input type="hidden" id="taskId">
      <div class="form-group">
        <label>User Name</label>
        <input type="text" id="taskUser">
      </div>
      <div class="form-group">
        <label>Task Title</label>
        <input type="text" id="taskTitle">
      </div>
      <div class="form-group">
        <label>Date Submitted</label>
        <input type="date" id="taskDate">
      </div>
      <div class="form-group">
        <label>Details</label>
        <textarea id="taskDetails"></textarea>
      </div>
      <div class="form-group">
        <label>Screenshot</label>
        <img id="taskScreenshot" src="" alt="Screenshot" style="max-width:100%;border:1px solid #ccc;border-radius:6px;">
      </div>
      <div class="modal-actions">
        <button type="button" class="save-btn" onclick="saveChanges()">Save Changes</button>
        <button type="button" class="action-btn approve-btn" onclick="approveTask()">Approve</button>
        <button type="button" class="action-btn decline-btn" onclick="declineTask()">Decline</button>
      </div>
    </form>
  </div>
</div>

<script>
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

const tasks = {
  1:{user:"Jane Doe",title:"Instagram Follow",date:"2025-09-16",details:"Follow @company for 3 days.",screenshot:"https://via.placeholder.com/400x200.png?text=Screenshot+1"},
  2:{user:"John Smith",title:"Facebook Like",date:"2025-09-15",details:"Like our FB page and share post.",screenshot:"https://via.placeholder.com/400x200.png?text=Screenshot+2"}
};

function openModal(id){
  const t = tasks[id];
  document.getElementById('taskId').value=id;
  document.getElementById('taskUser').value=t.user;
  document.getElementById('taskTitle').value=t.title;
  document.getElementById('taskDate').value=t.date;
  document.getElementById('taskDetails').value=t.details;
  document.getElementById('taskScreenshot').src=t.screenshot;
  document.getElementById('taskModal').style.display='flex';
}
function closeModal(){document.getElementById('taskModal').style.display='none';}
function saveChanges(){
  const id=document.getElementById('taskId').value;
  tasks[id].user=document.getElementById('taskUser').value;
  tasks[id].title=document.getElementById('taskTitle').value;
  tasks[id].date=document.getElementById('taskDate').value;
  tasks[id].details=document.getElementById('taskDetails').value;
  alert("Changes saved for task "+id+" (demo).");
  closeModal();
}
function approveTask(id){
  if(!id) id=document.getElementById('taskId').value;
  if(confirm("Approve this task?")) alert("Task "+id+" approved (demo).");
}
function declineTask(id){
  if(!id) id=document.getElementById('taskId').value;
  if(confirm("Decline this task?")) alert("Task "+id+" declined (demo).");
}

// Search filter
document.getElementById('searchInput').addEventListener('input',function(){
  const filter=this.value.toLowerCase();
  document.querySelectorAll('#taskBody tr').forEach(row=>{
    row.style.display=row.textContent.toLowerCase().includes(filter)?'':'none';
  });
});

// Entries filter
document.getElementById('entriesSelect').addEventListener('change',function(){
  const val=parseInt(this.value);
  document.querySelectorAll('#taskBody tr').forEach((row,i)=>{
    row.style.display=i<val?'':'none';
  });
});
</script>
</body>
</html>