<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Site Settings – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.main h1{margin-bottom:20px;}

/* ===== SETTINGS FORM ===== */
.settings-form{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  padding:25px;max-width:700px;
}
.settings-form label{font-weight:600;display:block;margin-bottom:6px;}
.settings-form input[type="text"],
.settings-form input[type="email"],
.settings-form input[type="url"],
.settings-form select{
  width:100%;padding:10px 12px;border:1px solid #ccc;border-radius:8px;font-size:15px;
  margin-bottom:15px;
}
.settings-form .form-row{
  display:flex;gap:20px;flex-wrap:wrap;
}
.settings-form .form-row > div{flex:1;min-width:200px;}
.settings-form button{
  background:#6b4bff;color:#fff;padding:10px 20px;border:none;border-radius:8px;
  font-size:15px;cursor:pointer;transition:opacity .2s;
}
.settings-form button:hover{opacity:.85;}

/* Responsive */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <button class="subnav-btn"><i class="fa-solid fa-wallet"></i> Finance <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="withdrawals.html">Withdrawals</a>
    <a href="#">Deposits</a>
  </div>
  <a href="announcements.html"><i class="fa-solid fa-bullhorn"></i> Announcements</a>
  <a href="settings.html"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main">
  <h1>Site Settings</h1>

  <form class="settings-form" id="settingsForm">
    <div class="form-row">
      <div>
        <label for="siteName">Site Name</label>
        <input type="text" id="siteName" value="My Awesome Platform" required>
      </div>
      <div>
        <label for="contactEmail">Contact Email</label>
        <input type="email" id="contactEmail" value="support@example.com" required>
      </div>
    </div>

    <label for="logoUrl">Logo URL</label>
    <input type="url" id="logoUrl" value="https://via.placeholder.com/120x40.png?text=Logo">

    <label for="maintenance">Maintenance Mode</label>
    <select id="maintenance">
      <option value="off" selected>Off</option>
      <option value="on">On</option>
    </select>

    <button type="submit"><i class="fa-solid fa-save"></i> Save Settings</button>
  </form>
</main>

<script>
// Sidebar toggle
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

// Save settings (demo)
document.getElementById('settingsForm').addEventListener('submit', e=>{
  e.preventDefault();
  const data = {
    siteName: document.getElementById('siteName').value.trim(),
    contactEmail: document.getElementById('contactEmail').value.trim(),
    logoUrl: document.getElementById('logoUrl').value.trim(),
    maintenance: document.getElementById('maintenance').value
  };
  // Replace with real backend request:
  console.log('Settings to save:', data);
  alert('Settings saved (demo only). Connect to backend to persist.');
});
</script>

</body>
</html>