<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>All Tasks – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* HEADER */
.header{position:fixed;top:0;left:0;width:100%;height:60px;background:#fff;display:flex;justify-content:space-between;align-items:center;padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* SIDEBAR */
.sidebar{width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;}
.sidebar a,.sidebar button.subnav-btn{color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;text-decoration:none;background:none;border:none;width:100%;text-align:left;cursor:pointer;font-size:15px;}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* MAIN */
.main{padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.top-bar{display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap;margin-bottom:20px;}
.search-input{padding:8px 14px;border:1px solid #ccc;border-radius:6px;width:250px;max-width:100%;}

/* TABLE */
.table-wrapper{width:100%;overflow-x:auto;-webkit-overflow-scrolling:touch;}
.tasks-table{width:100%;border-collapse:collapse;background:#fff;border-radius:10px;overflow:hidden;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
.tasks-table th, .tasks-table td{padding:14px 16px;text-align:left;border-bottom:1px solid #eee;font-size:15px;}
.tasks-table th{background:#6b4bff;color:#fff;font-weight:600;}
.action-btn{padding:6px 12px;margin:0 4px;border:none;border-radius:6px;font-size:13px;cursor:pointer;color:#fff;}
.edit-btn{background:#3498db;}
.delete-btn{background:#e74c3c;}
.action-btn:hover{opacity:0.85;}

/* MODAL */
.modal{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);display:none;justify-content:center;align-items:center;z-index:2000;}
.modal-content{background:#fff;border-radius:10px;max-width:600px;width:90%;padding:20px;position:relative;}
.modal-content h2{margin-bottom:15px;}
.close-btn{position:absolute;top:12px;right:12px;font-size:20px;cursor:pointer;color:#333;}
.form-group{margin-bottom:12px;}
.form-group label{display:block;margin-bottom:4px;font-weight:600;}
.form-group input,.form-group textarea{width:100%;padding:8px 10px;border:1px solid #ccc;border-radius:6px;font-size:14px;}
.form-group textarea{resize:vertical;min-height:60px;}
.modal-actions{margin-top:20px;display:flex;flex-wrap:wrap;gap:10px;}
.save-btn{background:#6b4bff;color:#fff;border:none;border-radius:6px;padding:8px 14px;cursor:pointer;}

/* RESPONSIVE */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
/* ===== Show Entries Styling ===== */
.top-bar label {
  font-size: 14px;
  color: #2d2a35;
  display: flex;
  align-items: center;
  gap: 6px;
}

#entriesSelect {
  padding: 6px 10px;
  border-radius: 6px;
  border: 1px solid #ccc;
  font-size: 14px;
  background: #fff;
  color: #2d2a35;
  cursor: pointer;
  transition: all 0.2s ease;
}

#entriesSelect:hover {
  border-color: #6b4bff;
}

#entriesSelect:focus {
  outline: none;
  border-color: #6b4bff;
  box-shadow: 0 0 3px rgba(107, 75, 255, 0.5);
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-briefcase"></i> Tasks <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">Approve Tasks</a>
    <a href="#">All Tasks</a>
  </div>
  <a href="#"><i class="fa-solid fa-users"></i> Users</a>
</nav>

<main class="main">
  <div class="top-bar">
  <h1>All Tasks</h1>
  <div style="display:flex;gap:10px;flex-wrap:wrap;">
    <label for="entriesSelect">Show 
      <select id="entriesSelect">
        <option value="5">5</option>
        <option value="10" selected>10</option>
        <option value="25">25</option>
        <option value="50">50</option>
      </select>
    entries</label>
    <input type="text" id="searchInput" class="search-input" placeholder="Search tasks...">
  </div>
</div>

  <div class="table-wrapper">
    <table class="tasks-table" id="tasksTable">
      <thead>
        <tr>
          <th>#</th><th>User</th><th>Task</th><th>Status</th><th>Date</th><th>Actions</th>
        </tr>
      </thead>
      <tbody id="taskBody">
        <tr>
          <td>1</td><td>Jane Doe</td><td>Instagram Follow</td><td>Approved</td><td>2025-09-16</td>
          <td>
            <button class="action-btn edit-btn" onclick="openModal(1)">Edit</button>
            <button class="action-btn delete-btn" onclick="deleteTask(1)">Delete</button>
          </td>
        </tr>
        <tr>
          <td>2</td><td>John Smith</td><td>Facebook Like</td><td>Rejected</td><td>2025-09-15</td>
          <td>
            <button class="action-btn edit-btn" onclick="openModal(2)">Edit</button>
            <button class="action-btn delete-btn" onclick="deleteTask(2)">Delete</button>
          </td>
        </tr>
        <!-- More tasks dynamically -->
      </tbody>
    </table>
  </div>
</main>

<!-- Modal -->
<div class="modal" id="taskModal">
  <div class="modal-content">
    <span class="close-btn" onclick="closeModal()">&times;</span>
    <h2>Edit Task</h2>
    <form id="taskForm">
      <input type="hidden" id="taskId">
      <div class="form-group">
        <label>User Name</label>
        <input type="text" id="taskUser">
      </div>
      <div class="form-group">
        <label>Task Title</label>
        <input type="text" id="taskTitle">
      </div>
      <div class="form-group">
        <label>Status</label>
        <input type="text" id="taskStatus">
      </div>
      <div class="form-group">
        <label>Date</label>
        <input type="date" id="taskDate">
      </div>
      <div class="form-group">
        <label>Details</label>
        <textarea id="taskDetails"></textarea>
      </div>
      <div class="modal-actions">
        <button type="button" class="save-btn" onclick="saveChanges()">Save Changes</button>
      </div>
    </form>
  </div>
</div>

<script>
const menuBtn = document.getElementById('menuBtn');
const sidebar = document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

const tasks = {
  1:{user:"Jane Doe",title:"Instagram Follow",status:"Approved",date:"2025-09-16",details:"Follow @company for 3 days."},
  2:{user:"John Smith",title:"Facebook Like",status:"Rejected",date:"2025-09-15",details:"Like FB page and share post."}
};

function openModal(id){
  const t = tasks[id];
  document.getElementById('taskId').value = id;
  document.getElementById('taskUser').value = t.user;
  document.getElementById('taskTitle').value = t.title;
  document.getElementById('taskStatus').value = t.status;
  document.getElementById('taskDate').value = t.date;
  document.getElementById('taskDetails').value = t.details;
  document.getElementById('taskModal').style.display = 'flex';
}
function closeModal(){document.getElementById('taskModal').style.display='none';}
function saveChanges(){
  const id = document.getElementById('taskId').value;
  tasks[id].user = document.getElementById('taskUser').value;
  tasks[id].title = document.getElementById('taskTitle').value;
  tasks[id].status = document.getElementById('taskStatus').value;
  tasks[id].date = document.getElementById('taskDate').value;
  tasks[id].details = document.getElementById('taskDetails').value;
  alert("Task "+id+" updated (demo).");
  closeModal();
}
function deleteTask(id){
  if(confirm("⚠️ Are you sure you want to DELETE this task?")){
    alert("Task "+id+" deleted (demo).");
  }
}

// Search filter
document.getElementById('searchInput').addEventListener('input',function(){
  const filter=this.value.toLowerCase();
  document.querySelectorAll('#taskBody tr').forEach(row=>{
    row.style.display=row.textContent.toLowerCase().includes(filter)?'':'none';
  });
});



const entriesSelect = document.getElementById('entriesSelect');
let currentEntries = parseInt(entriesSelect.value);

entriesSelect.addEventListener('change',()=>{
  currentEntries = parseInt(entriesSelect.value);
  displayTasks();
});

function displayTasks(){
  const tbody = document.getElementById('taskBody');
  tbody.innerHTML = '';
  const allTasks = Object.entries(tasks);
  const filteredTasks = allTasks.filter(([id, t])=>{
    const searchTerm = document.getElementById('searchInput').value.toLowerCase();
    return Object.values(t).some(v => v.toLowerCase().includes(searchTerm));
  });

  filteredTasks.slice(0,currentEntries).forEach(([id, t])=>{
    const tr = document.createElement('tr');
    tr.innerHTML = `<td>${id}</td>
      <td>${t.user}</td>
      <td>${t.title}</td>
      <td>${t.status}</td>
      <td>${t.date}</td>
      <td>
        <button class="action-btn edit-btn" onclick="openModal(${id})">Edit</button>
        <button class="action-btn delete-btn" onclick="deleteTask(${id})">Delete</button>
      </td>`;
    tbody.appendChild(tr);
  });
}

// Call displayTasks initially
displayTasks();

// Update table on search
document.getElementById('searchInput').addEventListener('input',displayTasks);
</script>
</body>
</html>