<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Login</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{
  
  min-height:80vh;
  display:flex;
  justify-content:center;
  align-items:center;
}
.login-container{
  background:#fff;
  border-radius:16px;
  box-shadow:0 8px 30px rgba(0,0,0,0.15);
  max-width:400px;
  width:90%;
  padding:40px 30px;
  text-align:center;
}
.login-container h1{
  color:#6b4bff;
  margin-bottom:25px;
  font-size:28px;
}
.login-container .form-group{
  margin-bottom:20px;
  text-align:left;
}
.login-container label{
  display:block;
  margin-bottom:6px;
  font-weight:600;
  color:#333;
}
.login-container input{
  width:100%;
  padding:10px 12px;
  border:1px solid #ccc;
  border-radius:8px;
  font-size:15px;
  transition:all 0.2s ease;
}
.login-container input:focus{
  border-color:#6b4bff;
  box-shadow:0 0 5px rgba(107,75,255,0.5);
  outline:none;
}
.login-container button{
  width:100%;
  padding:12px;
  background:#6b4bff;
  color:#fff;
  border:none;
  border-radius:8px;
  font-size:16px;
  cursor:pointer;
  transition:all 0.2s ease;
}
.login-container button:hover{
  background:#5933e0;
}
@media(max-width:500px){
  .login-container{padding:30px 20px;}
}
</style>
</head>
<body>

<div class="login-container">
  <h1>Admin Login</h1>
  <form action="admin_dashboard.html" method="POST">
    <div class="form-group">
      <label for="username"><i class="fa-solid fa-user"></i> Username</label>
      <input type="text" id="username" name="username" placeholder="Enter your username" required>
    </div>
    <div class="form-group">
      <label for="password"><i class="fa-solid fa-lock"></i> Password</label>
      <input type="password" id="password" name="password" placeholder="Enter your password" required>
    </div>
    <button type="submit">Login</button>
  </form>
</div>

</body>
</html>