<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{
  background:#f6f4fb;
  color:#2d2a35;
  min-height:100vh;
  overflow-x:hidden;
}

/* ===== HEADER ===== */
.header{
  position:fixed;
  top:0;left:0;
  width:100%;
  height:60px;
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:0 20px;
  box-shadow:0 3px 8px rgba(0,0,0,0.1);
  z-index:1001;
}
.menu-btn{
  font-size:24px;
  color:#6b4bff;
  background:none;
  border:none;
  cursor:pointer;
  display:none; /* hidden on desktop */
}
.admin-info{
  display:flex;
  align-items:center;
  gap:12px;
}
.admin-info img{
  width:36px;height:36px;
  border-radius:50%;
  border:2px solid #6b4bff;
  object-fit:cover;
}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;
  background:#6b4bff;
  color:#fff;
  position:fixed;
  top:0;left:0;
  bottom:0;
  padding-top:70px;
  overflow-y:auto;
  transition:transform .3s ease;
  z-index:1000;
}
.sidebar a,
.sidebar button.subnav-btn{
  color:#fff;
  padding:15px 20px;
  display:flex;
  align-items:center;
  gap:10px;
  text-decoration:none;
  background:none;
  border:none;
  width:100%;
  text-align:left;
  cursor:pointer;
  font-size:15px;
}
.sidebar a:hover,
.sidebar button.subnav-btn:hover{
  background:rgba(255,255,255,0.15);
}
.subnav-content{
  display:none;
  flex-direction:column;
  background:rgba(0,0,0,0.1);
}
.subnav-content.show{display:flex;}
.subnav-content a{
  padding:12px 40px;
  font-size:14px;
}

/* ===== MAIN ===== */
.main{
  flex:1;
  padding:80px 20px 20px;
  margin-left:240px;
  transition:margin-left .3s ease;
}

/* ===== CARDS GRID ===== */
.cards-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(160px,1fr));
  gap:20px;
}
.card{
  background:#fff;
  border-radius:16px;
  padding:20px;
  text-align:center;
  box-shadow:0 6px 18px rgba(0,0,0,.08);
  transition:transform .2s;
}
.card:hover{transform:translateY(-5px);}
.card i{font-size:28px;color:#6b4bff;margin-bottom:10px;}
.card h4{font-size:16px;margin-bottom:8px;}
.card p{font-size:20px;font-weight:700;color:#4b3cbf;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{
    transform:translateX(-100%);
  }
  .sidebar.show{
    transform:translateX(0);
  }
  .main{
    margin-left:0;
  }
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="#"><i class="fa-solid fa-gauge"></i> Dashboard</a>

  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">All Users</a>
    <a href="#">Banned Users</a>
    <a href="#">Admins</a>
  </div>

  <button class="subnav-btn"><i class="fa-solid fa-wallet"></i> Finance <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">Withdrawals</a>
    <a href="#">Deposits</a>
    <a href="#">Earnings</a>
  </div>

  <a href="#"><i class="fa-solid fa-bullhorn"></i> Announcements</a>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main" id="main">
  <h1 style="margin-bottom:20px;">Admin Dashboard</h1>
  <section class="cards-grid">
    <div class="card"><i class="fa-solid fa-users"></i><h4>Total Users</h4><p>1,245</p></div>
    <div class="card"><i class="fa-solid fa-user-slash"></i><h4>Banned Users</h4><p>32</p></div>
    <div class="card"><i class="fa-solid fa-wallet"></i><h4>Total Withdrawals</h4><p>₦2,500,000</p></div>
    <div class="card"><i class="fa-solid fa-coins"></i><h4>Total Deposits</h4><p>₦3,700,000</p></div>
    <div class="card"><i class="fa-solid fa-chart-line"></i><h4>Total Earnings</h4><p>₦5,200,000</p></div>
    <div class="card"><i class="fa-solid fa-briefcase"></i><h4>Active Vendors</h4><p>87</p></div>
    <div class="card"><i class="fa-solid fa-tasks"></i><h4>Pending Tasks</h4><p>41</p></div>
    <div class="card"><i class="fa-solid fa-envelope"></i><h4>Messages</h4><p>126</p></div>
  </section>
</main>

<script>
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');

// Toggle sidebar only on small screens
menuBtn.addEventListener('click',()=>{
  sidebar.classList.toggle('show');
});

// Subnav toggle
document.querySelectorAll('.subnav-btn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    btn.nextElementSibling.classList.toggle('show');
  });
});
</script>

</body>
</html>