<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Fund / Debit User – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.card{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  padding:30px;max-width:600px;margin:auto;
}
.card h2{margin-bottom:20px;font-size:22px;color:#4b3cbf;text-align:center;}
form label{display:block;margin-top:15px;font-weight:600;font-size:14px;}
form input,form select,form textarea{
  width:100%;padding:10px 12px;margin-top:5px;border:1px solid #ccc;
  border-radius:8px;font-size:15px;
}
form input:focus,form select:focus,form textarea:focus{
  outline:none;border-color:#6b4bff;box-shadow:0 0 0 2px rgba(107,75,255,0.2);
}
.submit-btn{
  margin-top:25px;background:#6b4bff;color:#fff;border:none;
  padding:12px 20px;font-size:15px;border-radius:8px;cursor:pointer;
}
.submit-btn:hover{opacity:0.9;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <a href="#"><i class="fa-solid fa-wallet"></i> Finance</a>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main">
  <div class="card">
    <h2>Fund / Debit User Account</h2>
    <form id="fundForm">
      <label>User ID or Email
        <input type="text" id="userIdentifier" placeholder="e.g. user@example.com" required>
      </label>
      <label>Action
        <select id="actionType" required>
          <option value="credit">Credit (Fund)</option>
          <option value="debit">Debit</option>
        </select>
      </label>
      <label>Amount
        <input type="number" id="amount" placeholder="Enter amount" min="1" required>
      </label>
      <label>Description
        <textarea id="description" rows="3" placeholder="Reason for this transaction"></textarea>
      </label>
      <button type="submit" class="submit-btn">Submit</button>
    </form>
  </div>
</main>

<script>
// Sidebar toggle
document.getElementById('menuBtn').onclick=()=>document.getElementById('sidebar').classList.toggle('show');
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.onclick=()=>btn.nextElementSibling.classList.toggle('show'));

// Form handler
document.getElementById('fundForm').addEventListener('submit',e=>{
  e.preventDefault();
  const user = document.getElementById('userIdentifier').value.trim();
  const action = document.getElementById('actionType').value;
  const amount = parseFloat(document.getElementById('amount').value);
  const desc = document.getElementById('description').value.trim();
  if(confirm(`⚠️ Confirm to ${action.toUpperCase()} ₦${amount} for user: ${user}?`)){
    // TODO: send AJAX/Fetch request to backend to process
    alert(`Demo only:\nUser: ${user}\nAction: ${action}\nAmount: ₦${amount}\nDescription: ${desc}`);
  }
});
</script>

</body>
</html>