<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Announcements – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.main h1{margin-bottom:20px;}

/* ===== FORM ===== */
.announce-form{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  padding:25px;max-width:700px;margin-bottom:30px;
}
.announce-form label{font-weight:600;display:block;margin-bottom:6px;}
.announce-form input[type="text"],
.announce-form textarea{
  width:100%;padding:10px 12px;border:1px solid #ccc;border-radius:8px;font-size:15px;
  margin-bottom:15px;
}
.announce-form textarea{min-height:120px;resize:vertical;}
.announce-form button{
  background:#6b4bff;color:#fff;padding:10px 20px;border:none;border-radius:8px;
  font-size:15px;cursor:pointer;transition:opacity .2s;
}
.announce-form button:hover{opacity:.85;}

/* ===== ANNOUNCEMENT LIST ===== */
.announce-list{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  padding:20px;max-width:900px;
}
.announce-item{
  border-bottom:1px solid #eee;padding:15px 0;
}
.announce-item:last-child{border-bottom:none;}
.announce-item h3{font-size:18px;margin-bottom:5px;color:#4b3cbf;}
.announce-item small{display:block;margin-bottom:8px;color:#777;}
.announce-item p{margin:0;font-size:15px;line-height:1.4;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <button class="subnav-btn"><i class="fa-solid fa-wallet"></i> Finance <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="withdrawals.html">Withdrawals</a>
    <a href="#">Deposits</a>
  </div>
  <a href="#"><i class="fa-solid fa-bullhorn"></i> Announcements</a>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main">
  <h1>Announcements</h1>

  <!-- Form to create new announcement -->
  <form class="announce-form" id="announceForm">
    <label for="title">Title</label>
    <input type="text" id="title" placeholder="Announcement title" required>

    <label for="message">Message</label>
    <textarea id="message" placeholder="Write your announcement..." required></textarea>

    <button type="submit"><i class="fa-solid fa-paper-plane"></i> Publish</button>
  </form>

  <!-- Existing announcements list -->
  <div class="announce-list" id="announceList">
    <!-- Example static announcement -->
    <div class="announce-item">
      <h3>Platform Update</h3>
      <small>2025-09-15 10:30 AM</small>
      <p>We have upgraded our servers for better performance. Thank you for your patience!</p>
    </div>
  </div>
</main>

<script>
// Sidebar toggle
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

// Handle new announcement submission (front-end demo)
const form=document.getElementById('announceForm');
const list=document.getElementById('announceList');

form.addEventListener('submit',e=>{
  e.preventDefault();
  const title=document.getElementById('title').value.trim();
  const message=document.getElementById('message').value.trim();
  if(!title || !message) return;

  // Create a new announcement item
  const item=document.createElement('div');
  item.className='announce-item';
  const now=new Date();
  item.innerHTML=`
    <h3>${title}</h3>
    <small>${now.toLocaleString()}</small>
    <p>${message}</p>
  `;
  // Add to top of list
  list.prepend(item);

  // Clear form
  form.reset();
  alert('Announcement published (demo only, save to backend in production).');
});
</script>

</body>
</html>