<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>All Users – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{
  background:#f6f4fb;
  color:#2d2a35;
  min-height:100vh;
  overflow-x:hidden;
}

/* ===== HEADER ===== */
.header{
  position:fixed;
  top:0;left:0;
  width:100%;
  height:60px;
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:0 20px;
  box-shadow:0 3px 8px rgba(0,0,0,0.1);
  z-index:1001;
}
.menu-btn{
  font-size:24px;
  color:#6b4bff;
  background:none;
  border:none;
  cursor:pointer;
  display:none; /* show only on small screens */
}
.admin-info{
  display:flex;
  align-items:center;
  gap:12px;
}
.admin-info img{
  width:36px;height:36px;
  border-radius:50%;
  border:2px solid #6b4bff;
  object-fit:cover;
}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;
  background:#6b4bff;
  color:#fff;
  position:fixed;
  top:0;left:0;
  bottom:0;
  padding-top:70px;
  overflow-y:auto;
  transition:transform .3s ease;
  z-index:1000;
}
.sidebar a,
.sidebar button.subnav-btn{
  color:#fff;
  padding:15px 20px;
  display:flex;
  align-items:center;
  gap:10px;
  text-decoration:none;
  background:none;
  border:none;
  width:100%;
  text-align:left;
  cursor:pointer;
  font-size:15px;
}
.sidebar a:hover,
.sidebar button.subnav-btn:hover{
  background:rgba(255,255,255,0.15);
}
.subnav-content{
  display:none;
  flex-direction:column;
  background:rgba(0,0,0,0.1);
}
.subnav-content.show{display:flex;}
.subnav-content a{
  padding:12px 40px;
  font-size:14px;
}

/* ===== MAIN ===== */
.main{
  flex:1;
  padding:80px 20px 20px;
  margin-left:240px;
  transition:margin-left .3s ease;
}

/* ===== TABLE ===== */
.table-container{
  background:#fff;
  border-radius:16px;
  box-shadow:0 6px 18px rgba(0,0,0,.08);
  overflow-x:auto;
}
.table-controls{
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:12px 16px;
  flex-wrap:wrap;
  gap:10px;
}
.table-controls label{
  font-size:14px;
  font-weight:500;
}
.table-controls select{
  padding:6px 10px;
  border-radius:6px;
  border:1px solid #ccc;
  font-size:14px;
}
.table-controls input{
  padding:6px 10px;
  border-radius:6px;
  border:1px solid #ccc;
  font-size:14px;
}

table{
  width:100%;
  border-collapse:collapse;
  min-width:800px;
}
th, td{
  padding:14px 16px;
  text-align:left;
  border-bottom:1px solid #eee;
}
th{
  background:#f1effa;
  font-weight:600;
}
.action-btn{
  padding:6px 12px;
  border:none;
  border-radius:6px;
  cursor:pointer;
  font-size:14px;
  color:#fff;
  margin-right:8px;
  transition:opacity .2s;
}
.view-btn{background:#6b4bff;}
.freeze-btn{background:#e74c3c;}
.action-btn:hover{opacity:.85;}

/* ===== Responsive ===== */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <button class="subnav-btn"><i class="fa-solid fa-wallet"></i> Finance <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="#">Withdrawals</a>
    <a href="#">Deposits</a>
  </div>
  <a href="#"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main" id="main">
  <h1 style="margin-bottom:20px;">All Users</h1>

  <div class="table-container">
    <div class="table-controls">
      <div>
        <label>Show 
          <select id="entriesSelect">
            <option>10</option>
            <option>25</option>
            <option>50</option>
            <option>100</option>
          </select> 
        entries</label>
      </div>
      <div>
        <label>Search: <input type="text" id="searchInput" placeholder="Search user..."></label>
      </div>
    </div>

    <table id="usersTable">
      <thead>
        <tr>
          <th>#ID</th>
          <th>Full Name</th>
          <th>Email</th>
          <th>Username</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>1</td>
          <td>Jane Doe</td>
          <td>jane@example.com</td>
          <td>jane_d</td>
          <td>Active</td>
          <td>
            <button class="action-btn view-btn">View</button>
            <button class="action-btn freeze-btn">Freeze</button>
          </td>
        </tr>
        <tr>
          <td>2</td>
          <td>John Smith</td>
          <td>john@example.com</td>
          <td>john_s</td>
          <td>Active</td>
          <td>
            <button class="action-btn view-btn">View</button>
            <button class="action-btn freeze-btn">Freeze</button>
          </td>
        </tr>
        <!-- More rows -->
      </tbody>
    </table>
  </div>
</main>

<script>
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>{ sidebar.classList.toggle('show'); });

// subnav toggle
document.querySelectorAll('.subnav-btn').forEach(btn=>{
  btn.addEventListener('click',()=> btn.nextElementSibling.classList.toggle('show'));
});

// === Show Entries + Search (simple JS filter) ===
const entriesSelect=document.getElementById('entriesSelect');
const searchInput=document.getElementById('searchInput');
const usersTable=document.getElementById('usersTable').getElementsByTagName('tbody')[0];
const allRows=[...usersTable.rows];

function updateTable(){
  let limit=parseInt(entriesSelect.value);
  let search=searchInput.value.toLowerCase();
  let visibleCount=0;
  allRows.forEach(row=>{
    let text=row.innerText.toLowerCase();
    let match=text.includes(search);
    if(match && visibleCount<limit){
      row.style.display='';
      visibleCount++;
    }else{
      row.style.display='none';
    }
  });
}
entriesSelect.addEventListener('change',updateTable);
searchInput.addEventListener('keyup',updateTable);
updateTable();
</script>

</body>
</html>