<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Pricing Management – Admin</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;}
body{background:#f6f4fb;color:#2d2a35;min-height:100vh;overflow-x:hidden;}

/* ===== HEADER ===== */
.header{
  position:fixed;top:0;left:0;width:100%;height:60px;
  background:#fff;display:flex;justify-content:space-between;align-items:center;
  padding:0 20px;box-shadow:0 3px 8px rgba(0,0,0,0.1);z-index:1001;
}
.menu-btn{font-size:24px;color:#6b4bff;background:none;border:none;cursor:pointer;display:none;}
.admin-info{display:flex;align-items:center;gap:12px;}
.admin-info img{width:36px;height:36px;border-radius:50%;border:2px solid #6b4bff;object-fit:cover;}

/* ===== SIDEBAR ===== */
.sidebar{
  width:240px;background:#6b4bff;color:#fff;position:fixed;top:0;left:0;bottom:0;
  padding-top:70px;overflow-y:auto;transition:transform .3s ease;z-index:1000;
}
.sidebar a,.sidebar button.subnav-btn{
  color:#fff;padding:15px 20px;display:flex;align-items:center;gap:10px;
  text-decoration:none;background:none;border:none;width:100%;text-align:left;
  cursor:pointer;font-size:15px;
}
.sidebar a:hover,.sidebar button.subnav-btn:hover{background:rgba(255,255,255,0.15);}
.subnav-content{display:none;flex-direction:column;background:rgba(0,0,0,0.1);}
.subnav-content.show{display:flex;}
.subnav-content a{padding:12px 40px;font-size:14px;}

/* ===== MAIN ===== */
.main{flex:1;padding:80px 20px 20px;margin-left:240px;transition:margin-left .3s ease;}
.main h1{margin-bottom:20px;}
.add-btn{
  background:#6b4bff;color:#fff;padding:10px 20px;border:none;border-radius:8px;
  font-size:15px;cursor:pointer;transition:opacity .2s;margin-bottom:20px;
}
.add-btn:hover{opacity:.85;}

/* ===== TABLE ===== */
.table-container{
  background:#fff;border-radius:16px;box-shadow:0 6px 18px rgba(0,0,0,.08);
  overflow-x:auto;
}
table{width:100%;border-collapse:collapse;min-width:700px;}
th,td{padding:14px 16px;text-align:left;border-bottom:1px solid #eee;}
th{background:#f1effa;font-weight:600;}
.action-btn{
  padding:6px 12px;border:none;border-radius:6px;cursor:pointer;font-size:14px;
  color:#fff;margin-right:8px;transition:opacity .2s;
}
.edit-btn{background:#6b4bff;}
.delete-btn{background:#e74c3c;}
.action-btn:hover{opacity:.85;}

/* ===== MODAL ===== */
.modal{
  position:fixed;top:0;left:0;width:100%;height:100%;
  background:rgba(0,0,0,.5);display:none;align-items:center;justify-content:center;z-index:2000;
}
.modal.show{display:flex;}
.modal-content{
  background:#fff;border-radius:16px;padding:25px;max-width:400px;width:90%;
  box-shadow:0 6px 18px rgba(0,0,0,.25);
}
.modal-content h2{margin-bottom:20px;font-size:20px;}
.modal-content label{display:block;margin-bottom:6px;font-weight:600;}
.modal-content input{
  width:100%;padding:10px 12px;margin-bottom:15px;
  border:1px solid #ccc;border-radius:8px;font-size:15px;
}
.modal-content .modal-actions{
  display:flex;justify-content:flex-end;gap:10px;
}
.modal-content button{
  padding:8px 16px;border:none;border-radius:6px;font-size:14px;cursor:pointer;
}
.save-btn{background:#6b4bff;color:#fff;}
.cancel-btn{background:#ccc;color:#000;}

/* Responsive */
@media(max-width:1024px){
  .menu-btn{display:block;}
  .sidebar{transform:translateX(-100%);}
  .sidebar.show{transform:translateX(0);}
  .main{margin-left:0;}
}
</style>
</head>
<body>

<header class="header">
  <button class="menu-btn" id="menuBtn"><i class="fa-solid fa-bars"></i></button>
  <div class="admin-info">
    <img src="https://via.placeholder.com/40x40.png?text=A" alt="Admin">
    <span>Admin Name</span>
  </div>
</header>

<nav class="sidebar" id="sidebar">
  <a href="dashboard.html"><i class="fa-solid fa-gauge"></i> Dashboard</a>
  <button class="subnav-btn"><i class="fa-solid fa-users"></i> Users <i class="fa fa-caret-down" style="margin-left:auto"></i></button>
  <div class="subnav-content">
    <a href="users.html">All Users</a>
    <a href="#">Banned Users</a>
  </div>
  <a href="pricing.html"><i class="fa-solid fa-tags"></i> Pricing</a>
  <a href="settings.html"><i class="fa-solid fa-cogs"></i> Settings</a>
  <a href="#"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
</nav>

<main class="main">
  <h1>Pricing Management</h1>

  <button class="add-btn" id="addBtn"><i class="fa-solid fa-plus"></i> Add Pricing</button>

  <div class="table-container">
    <table id="pricingTable">
      <thead>
        <tr>
          <th>#</th>
          <th>Title</th>
          <th>Price (₦)</th>
          <th>Category</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <!-- Filled dynamically -->
      </tbody>
    </table>
  </div>
</main>

<!-- ===== Modal for Add/Edit ===== -->
<div class="modal" id="pricingModal">
  <div class="modal-content">
    <h2 id="modalTitle">Add Pricing</h2>
    <label for="priceTitle">Title</label>
    <input type="text" id="priceTitle" required>
    <label for="priceAmount">Price (₦)</label>
    <input type="number" id="priceAmount" required>
    <label for="priceCategory">Category</label>
    <input type="text" id="priceCategory" required>
    <div class="modal-actions">
      <button class="cancel-btn" id="cancelModal">Cancel</button>
      <button class="save-btn" id="saveModal">Save</button>
    </div>
  </div>
</div>

<script>
/* Sidebar toggle */
const menuBtn=document.getElementById('menuBtn');
const sidebar=document.getElementById('sidebar');
menuBtn.addEventListener('click',()=>sidebar.classList.toggle('show'));
document.querySelectorAll('.subnav-btn').forEach(btn=>btn.addEventListener('click',()=>btn.nextElementSibling.classList.toggle('show')));

/* Demo Data */
let pricingData = [
  {id:1,title:'1GB Data',price:500,category:'Data'},
  {id:2,title:'Task Completion',price:200,category:'Task'}
];

/* Elements */
const pricingTableBody = document.querySelector('#pricingTable tbody');
const modal = document.getElementById('pricingModal');
const modalTitle = document.getElementById('modalTitle');
const priceTitle = document.getElementById('priceTitle');
const priceAmount = document.getElementById('priceAmount');
const priceCategory = document.getElementById('priceCategory');
const saveModal = document.getElementById('saveModal');
const cancelModal = document.getElementById('cancelModal');
let editId = null;

/* Render Table */
function renderTable(){
  pricingTableBody.innerHTML = '';
  pricingData.forEach((item, idx)=>{
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td>${idx+1}</td>
      <td>${item.title}</td>
      <td>${item.price}</td>
      <td>${item.category}</td>
      <td>
        <button class="action-btn edit-btn" onclick="editPricing(${item.id})"><i class="fa fa-edit"></i> Edit</button>
        <button class="action-btn delete-btn" onclick="deletePricing(${item.id})"><i class="fa fa-trash"></i> Delete</button>
      </td>
    `;
    pricingTableBody.appendChild(tr);
  });
}
renderTable();

/* Open Modal */
document.getElementById('addBtn').addEventListener('click',()=>{
  editId = null;
  modalTitle.textContent = 'Add Pricing';
  priceTitle.value = '';
  priceAmount.value = '';
  priceCategory.value = '';
  modal.classList.add('show');
});

/* Cancel Modal */
cancelModal.addEventListener('click',()=>modal.classList.remove('show'));

/* Save/Add/Edit */
saveModal.addEventListener('click',()=>{
  const title = priceTitle.value.trim();
  const amount = parseFloat(priceAmount.value);
  const category = priceCategory.value.trim();
  if(!title || isNaN(amount) || !category){
    alert('Please fill all fields correctly');
    return;
  }
  if(editId){
    const item = pricingData.find(p=>p.id===editId);
    item.title = title; item.price = amount; item.category = category;
  }else{
    pricingData.push({id:Date.now(), title, price:amount, category});
  }
  modal.classList.remove('show');
  renderTable();
});

/* Edit Function */
window.editPricing = function(id){
  const item = pricingData.find(p=>p.id===id);
  editId = id;
  modalTitle.textContent = 'Edit Pricing';
  priceTitle.value = item.title;
  priceAmount.value = item.price;
  priceCategory.value = item.category;
  modal.classList.add('show');
}

/* Delete Function */
window.deletePricing = function(id){
  if(confirm('Are you sure you want to delete this pricing item?')){
    pricingData = pricingData.filter(p=>p.id!==id);
    renderTable();
  }
}
</script>

</body>
</html>